/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.issr.iet.weblogic.beans;

import com.ibm.issr.iet.util.xml.XMLUtils;
import com.ibm.issr.iet.weblogic.beans.JMXAttribute;
import javax.management.AttributeNotFoundException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JMXRelatedBean
extends JMXAttribute {
    private String referencedBean;
    private String containedBean;
    private boolean isReference = false;
    private String factory;
    private String relatedBean;

    public String getReferencedBean() {
        return this.referencedBean;
    }

    public String getContainedBean() {
        return this.containedBean;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setRelatedBean(String relatedBean) {
        this.relatedBean = relatedBean;
    }

    public boolean isRelatedBeanSet() {
        return !this.relatedBean.isEmpty();
    }

    private JMXRelatedBean(String name, String type, String referencedBean, String containedBean, String factory) throws ClassNotFoundException {
        super(name, "ObjectName", null, "false");
        if (referencedBean != null && !"".equals(referencedBean.trim())) {
            this.isReference = true;
        }
        if (referencedBean.matches(".*\\[]") || containedBean.matches(".*\\[]")) {
            this.isArray = true;
        }
        this.referencedBean = referencedBean;
        this.containedBean = containedBean;
        this.relatedBean = "";
        this.factory = factory;
    }

    public static JMXRelatedBean loadFromNode(Node node, XMLUtils xmlUtils) throws ClassNotFoundException, AttributeNotFoundException {
        Element jmxBeanProperty = (Element)node;
        String name = jmxBeanProperty.getAttribute("name");
        String referencedBean = jmxBeanProperty.getAttribute("referencedBean");
        String containedBean = jmxBeanProperty.getAttribute("containedBean");
        String factory = jmxBeanProperty.getAttribute("factory");
        JMXRelatedBean property = new JMXRelatedBean(name, null, referencedBean, containedBean, factory);
        return property;
    }

    public String getRelatedBean() {
        if (this.relatedBean.isEmpty()) {
            return this.referencedBean.isEmpty() ? this.containedBean : this.referencedBean;
        }
        return this.relatedBean;
    }
}

