/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.issr.iet.jmx.OrderedProperties;
import com.ibm.issr.iet.weblogic.WebLogicConnection;
import com.ibm.issr.iet.weblogic.WebLogicHandler;
import com.ibm.issr.iet.weblogic.WebLogicMBeanServer;
import com.ibm.issr.iet.weblogic.beans.JMXBean;
import com.ibm.issr.iet.weblogic.configuration.WSLMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.xml.xpath.XPathExpressionException;

public class Main {
    private final String[] args;
    private Properties inputProperties;
    private Properties outputProperties;
    private WebLogicHandler webLogicHandler;
    private OrderedProperties jmxProperties;
    private JMXBean bean;
    private String outputPropertiesPath;

    public static void main(String[] args) {
        System.exit(new Main(args).execute());
    }

    private Main(String[] args) {
        this.args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute() {
        int result = 0;
        int returnCode = 0;
        try {
            if (this.args.length != 4) {
                throw new RuntimeException("Unexepected number of plugin arguments. Expected arguments: Action, BeanType, InputPropsFile, OutputPropsFile.");
            }
            String action = this.args[0];
            String beanType = this.args[1];
            String inputPropertiesPath = this.args[2];
            this.outputPropertiesPath = this.args[3];
            File inputPropertiesFile = new File(inputPropertiesPath);
            FileInputStream inputPropertiesStream = null;
            this.inputProperties = new Properties();
            try {
                try {
                    inputPropertiesStream = new FileInputStream(inputPropertiesFile);
                    this.inputProperties.load(inputPropertiesStream);
                }
                finally {
                    if (inputPropertiesStream != null) {
                        ((InputStream)inputPropertiesStream).close();
                    }
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not locate input properties file at " + inputPropertiesPath);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load properties file.");
            }
            this.outputProperties = new Properties();
            String hostName = this.inputProperties.getProperty("hostname");
            String port = this.inputProperties.getProperty("port");
            String user = this.inputProperties.getProperty("userid");
            String password = this.inputProperties.getProperty("password");
            try {
                WSLMetadata.initialize((String)((String)this.inputProperties.get("wlsMetadataXML")));
            }
            catch (AttributeNotFoundException e) {
                System.err.println(String.format("Unable to initialize WSLMetadata. Error: %s", e.getMessage()));
                returnCode = 1;
            }
            catch (XPathExpressionException e) {
                System.err.println(String.format("Unable to initialize WSLMetadata. Error: %s", e.getMessage()));
                returnCode = 1;
            }
            catch (ClassNotFoundException e) {
                System.err.println(String.format("Unable to initialize WSLMetadata. Error: %s", e.getMessage()));
                returnCode = 1;
            }
            catch (IOException e) {
                System.err.println(String.format("Unable to initialize WSLMetadata. Error: %s", e.getMessage()));
                returnCode = 1;
            }
            if (returnCode > 0) {
                System.out.println("Execution Failed.");
                int e = returnCode;
                return e;
            }
            this.jmxProperties = new OrderedProperties();
            try {
                this.jmxProperties.load((InputStream)new FileInputStream((String)this.inputProperties.get("jmxProperties")));
            }
            catch (FileNotFoundException e) {
                System.err.println(String.format("Unable to locate JMX properties file. Error: %s", e.getMessage()));
                returnCode = 1;
            }
            catch (IOException e) {
                System.err.println(String.format("Unable to open JMX properties file. Error: %s", e.getMessage()));
                returnCode = 1;
            }
            if (returnCode > 0) {
                System.out.println("Execution Failed.");
                int e = returnCode;
                return e;
            }
            WebLogicConnection webLogicConnection = null;
            try {
                webLogicConnection = new WebLogicConnection(hostName, port, user, password, WebLogicMBeanServer.EDIT);
            }
            catch (MalformedURLException e) {
                System.err.println(String.format("Error connection to WebLogic, bad URL: %s", e.getMessage()));
                returnCode = 1;
            }
            catch (IOException e) {
                System.err.println(String.format("Unable to connect to WebLogic: %s", e.getMessage()));
                returnCode = 1;
            }
            if (returnCode > 0) {
                System.out.println("Failure Connecting to WebLogic.");
                int e = returnCode;
                return e;
            }
            this.bean = WSLMetadata.getInstance().getJMXBean(beanType);
            this.webLogicHandler = new WebLogicHandler(webLogicConnection);
            if (!action.equals("Delete")) {
                try {
                    this.webLogicHandler.updateOrCreateBean(this.bean, this.inputProperties, this.jmxProperties);
                }
                catch (MalformedObjectNameException e) {
                    System.err.println(String.format("Error: %s", e.getMessage()));
                    returnCode = 1;
                }
                catch (MBeanException e) {
                    System.err.println(String.format("Bean Exception managing Bean: %s", e.getMessage()));
                    e.printStackTrace();
                    returnCode = 1;
                }
                catch (ReflectionException e) {
                    System.err.println(String.format("Reflection Exception managing Bean: %s", e.getMessage()));
                    System.err.println("My cause is " + e.getCause());
                    System.err.println("My target exception is " + e.getTargetException());
                    for (StackTraceElement element : e.getStackTrace()) {
                        System.err.println(element.toString());
                    }
                    returnCode = 1;
                }
                catch (OperationsException e) {
                    System.err.println(String.format("Could not open edit session. Error: %s", e.getMessage()));
                    e.printStackTrace();
                    returnCode = 1;
                }
                catch (IllegalArgumentException e) {
                    System.err.println(String.format("Argument Exception managing Bean: %s", e.getMessage()));
                    e.printStackTrace();
                    returnCode = 1;
                }
                catch (IOException e) {
                    System.err.println(String.format("IO exception managing Bean: %s", e.getMessage()));
                    e.printStackTrace();
                    returnCode = 1;
                }
            } else {
                this.webLogicHandler.deleteBean(this.bean, this.inputProperties, this.jmxProperties);
            }
        }
        catch (RuntimeException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = 1;
        }
        finally {
            File outputPropertiesFile = new File(this.outputPropertiesPath);
            try {
                FileOutputStream outputPropertiesStream = new FileOutputStream(outputPropertiesFile);
                this.outputProperties.store(outputPropertiesStream, "");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not locate output properties file at " + this.outputPropertiesPath);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load properties file");
            }
        }
        if (returnCode > 0) {
            result = returnCode;
        }
        return result;
    }
}

