/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.issr.iet.weblogic.beans;

import com.ibm.issr.iet.util.xml.XMLUtils;
import com.ibm.issr.iet.weblogic.beans.CreationParam;
import com.ibm.issr.iet.weblogic.beans.JMXAttribute;
import com.ibm.issr.iet.weblogic.beans.JMXProperty;
import com.ibm.issr.iet.weblogic.beans.JMXRelatedBean;
import com.ibm.issr.iet.weblogic.beans.JMXSubType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXBean {
    private String name;
    private String path;
    private Set<CreationParam> creationParams = new HashSet<CreationParam>();
    private Set<String> params = new HashSet<String>();
    private Map<String, JMXProperty> properties = new ConcurrentHashMap<String, JMXProperty>();
    private boolean hasSubTypes = false;
    private String methodSuffix;

    private JMXBean(String name, String path, String methodSuffix) {
        this.name = name;
        this.path = path;
        this.methodSuffix = methodSuffix;
        Pattern pattern = Pattern.compile("\\[\\$\\w*\\]");
        Matcher matcher = pattern.matcher(path);
        while (matcher.find()) {
            this.params.add(matcher.group().substring(2, matcher.group().length() - 1));
        }
    }

    private void addProperty(JMXProperty property) {
        this.properties.put(property.getName(), property);
    }

    private void addCreationParam(CreationParam property) {
        this.creationParams.add(property);
    }

    public JMXProperty getProperty(String property) throws AttributeNotFoundException {
        JMXProperty prop;
        int index = property.indexOf(91);
        if (index > 0) {
            property = property.substring(0, index);
        }
        if ((prop = this.properties.get(property)) == null) {
            throw new AttributeNotFoundException(String.format("Attribute %s not found for bean %s", property, this.name));
        }
        return prop;
    }

    public Set<String> getParams() {
        return this.params;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getLookup() {
        String suffix = this.methodSuffix;
        if (this.methodSuffix == null || "".equals(this.methodSuffix.trim())) {
            suffix = this.name;
        }
        return "lookup" + suffix;
    }

    public String getCreate() {
        String suffix = this.methodSuffix;
        if (this.methodSuffix == null || "".equals(this.methodSuffix.trim())) {
            suffix = this.name;
        }
        return "create" + suffix;
    }

    public String getDestroy() {
        String suffix = this.methodSuffix;
        if (this.methodSuffix == null || "".equals(this.methodSuffix.trim())) {
            suffix = this.name;
        }
        return "destroy" + suffix;
    }

    public Map<String, JMXProperty> getProperties() {
        return this.properties;
    }

    public Set<CreationParam> getCreationParams() {
        return this.creationParams;
    }

    public boolean hasCreationParams() {
        return this.creationParams.size() > 0;
    }

    public boolean hasSubTypes() {
        return this.hasSubTypes;
    }

    private void lockProperties() {
        this.properties = Collections.unmodifiableMap(this.properties);
        this.params = Collections.unmodifiableSet(this.params);
    }

    public static JMXBean loadFromNode(Node node, XMLUtils xmlUtils) throws XPathExpressionException, ClassNotFoundException, AttributeNotFoundException {
        JMXProperty property;
        int i;
        Element jmxBeanElement = (Element)node;
        String name = jmxBeanElement.getAttribute("name");
        String path = jmxBeanElement.getAttribute("path");
        String methodSuffix = jmxBeanElement.getAttribute("methodSuffix");
        JMXBean bean = new JMXBean(name, path, methodSuffix);
        NodeList properties = xmlUtils.xPathQuery(node, "//attribute", NodeList.class);
        for (i = 0; i < properties.getLength(); ++i) {
            property = JMXAttribute.loadFromNode(properties.item(i), xmlUtils);
            bean.addProperty(property);
        }
        properties = xmlUtils.xPathQuery(node, "//relatedBean", NodeList.class);
        for (i = 0; i < properties.getLength(); ++i) {
            property = JMXRelatedBean.loadFromNode(properties.item(i), xmlUtils);
            bean.addProperty(property);
        }
        properties = xmlUtils.xPathQuery(node, "//creationParam", NodeList.class);
        for (i = 0; i < properties.getLength(); ++i) {
            property = CreationParam.loadFromNode(properties.item(i), xmlUtils);
            bean.addCreationParam((CreationParam)property);
        }
        properties = xmlUtils.xPathQuery(node, "//subType", NodeList.class);
        if (properties.getLength() > 0) {
            for (i = 0; i < properties.getLength(); ++i) {
                property = JMXSubType.loadFromNode(properties.item(i), xmlUtils);
                bean.addProperty(property);
            }
            bean.hasSubTypes = true;
        }
        bean.lockProperties();
        return bean;
    }
}

