/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.issr.iet.weblogic.security;

import com.ibm.issr.iet.weblogic.security.Operation;
import com.ibm.issr.iet.weblogic.security.Realm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityManagementSAXParser
extends DefaultHandler {
    protected String provider = "Provider";
    protected static final String PARAM = "param";
    protected static final String OPERATION = "operation";
    protected static final String NAME = "name";
    protected static final String REALM = "Realm";
    protected List<Realm> realmsList;
    protected String securityXmlFileName;
    protected Map<String, String> paramTmp = new HashMap<String, String>();
    protected List<Map<String, String>> operationParamsTmp = new ArrayList<Map<String, String>>();
    protected Operation operationTmp;
    protected Realm realmTmp;

    public SecurityManagementSAXParser(String userGroupXmlFileName, String provider) {
        this.securityXmlFileName = userGroupXmlFileName;
        this.provider = provider;
        this.realmsList = new ArrayList<Realm>();
        this.parseDocument();
    }

    public List<Realm> getRealms() {
        return this.realmsList;
    }

    private void parseDocument() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.securityXmlFileName, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            System.err.println("ParserConfig error");
        }
        catch (SAXException e) {
            System.err.println("SAXException : xml not well formed");
        }
        catch (IOException e) {
            System.err.println("IO error");
        }
    }

    @Override
    public void startElement(String s, String s1, String elementName, Attributes attributes) throws SAXException {
        if (elementName.equalsIgnoreCase(REALM)) {
            String realmName = attributes.getValue(NAME);
            String providerName = attributes.getValue(this.provider);
            if (realmName == null || "".equals(realmName.trim()) || providerName == null || "".equals(providerName)) {
                throw new SAXException("Realm name or authentication provider must not be empty");
            }
            this.realmTmp = new Realm(realmName, providerName);
        } else if (elementName.equalsIgnoreCase(OPERATION)) {
            this.operationTmp = Operation.valueOf(attributes.getValue(NAME));
            this.operationParamsTmp = new ArrayList<Map<String, String>>();
        } else if (elementName.equalsIgnoreCase(PARAM)) {
            this.paramTmp = new HashMap<String, String>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.paramTmp.put(attributes.getQName(i), attributes.getValue(i));
            }
        }
    }

    @Override
    public void endElement(String s, String s1, String elementName) throws SAXException {
        if (elementName.equalsIgnoreCase(REALM)) {
            this.realmsList.add(this.realmTmp);
        } else if (elementName.equalsIgnoreCase(OPERATION)) {
            this.realmTmp.addOperation(this.operationTmp, this.operationParamsTmp);
        } else if (elementName.equalsIgnoreCase(PARAM)) {
            this.operationParamsTmp.add(this.paramTmp);
        }
    }
}

