/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.issr.iet.weblogic.beans;

import java.util.ArrayList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JMXPropertyType {
    STRING(String.class),
    LONG(Long.TYPE, Long.class),
    INTEGER(Integer.TYPE, Integer.class),
    DOUBLE(Double.TYPE, Double.class),
    FLOAT(Float.TYPE, Float.class),
    BOOLEAN(Boolean.TYPE, Boolean.class),
    CHARACTER(Character.TYPE, Character.class),
    BYTE(Byte.TYPE, Byte.class),
    SHORT(Short.TYPE, Short.class),
    OBJECTNAME(ObjectName.class);

    Class<?> clazz;
    Class<?> clazzType;

    private JMXPropertyType(Class<?> clazz) {
        this.clazz = clazz;
        this.clazzType = clazz;
    }

    private JMXPropertyType(Class<?> clazzType, Class<?> clazz) {
        this.clazz = clazz;
        this.clazzType = clazzType;
    }

    public Class<?> getClassType() {
        return this.clazz;
    }

    public static Class<?> getObjectType(Class<?> clazz) {
        for (JMXPropertyType type : JMXPropertyType.values()) {
            if (!clazz.equals(type.getClassType())) continue;
            return type.getClassType();
        }
        return null;
    }

    public static Object parse(Object object, JMXPropertyType type, boolean isArray) {
        if (object instanceof String) {
            switch (type) {
                case BOOLEAN: {
                    Object result;
                    if (isArray) {
                        String[] values = ((String)object).split(",");
                        boolean[] parsedValues = new boolean[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            parsedValues[i] = Boolean.parseBoolean(values[i]);
                        }
                        result = parsedValues;
                    } else {
                        result = Boolean.parseBoolean((String)object);
                    }
                    return result;
                }
                case INTEGER: {
                    Object result;
                    if (isArray) {
                        String[] values = ((String)object).split(",");
                        int[] parsedValues = new int[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            parsedValues[i] = Integer.parseInt(values[i]);
                        }
                        result = parsedValues;
                    } else {
                        result = Integer.parseInt((String)object);
                    }
                    return result;
                }
                case LONG: {
                    if (isArray) {
                        String[] values = ((String)object).split(",");
                        long[] parsedValues = new long[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            parsedValues[i] = Long.parseLong(values[i]);
                        }
                        return parsedValues;
                    }
                    Long result = Long.parseLong((String)object);
                    return result;
                }
                case BYTE: {
                    if (isArray) {
                        String[] values = ((String)object).split(",");
                        byte[] parsedValues = new byte[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            parsedValues[i] = Byte.parseByte(values[i]);
                        }
                        return parsedValues;
                    }
                    Byte result = Byte.parseByte((String)object);
                    return result;
                }
                case CHARACTER: {
                    if (isArray) {
                        String[] values = ((String)object).split(",");
                        ArrayList<Character> parsedValues = new ArrayList<Character>();
                        for (int i = 0; i < values.length; ++i) {
                            for (char c : values[i].toCharArray()) {
                                parsedValues.add(Character.valueOf(c));
                            }
                        }
                        return parsedValues;
                    }
                    Byte result = Byte.parseByte((String)object);
                    return result;
                }
                case DOUBLE: {
                    if (isArray) {
                        String[] values = ((String)object).split(",");
                        double[] parsedValues = new double[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            parsedValues[i] = Double.parseDouble(values[i]);
                        }
                        return parsedValues;
                    }
                    Double result = Double.parseDouble((String)object);
                    return result;
                }
                case FLOAT: {
                    if (isArray) {
                        String[] values = ((String)object).split(",");
                        float[] parsedValues = new float[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            parsedValues[i] = Float.parseFloat(values[i]);
                        }
                        return parsedValues;
                    }
                    Float result = Float.valueOf(Float.parseFloat((String)object));
                    return result;
                }
                case SHORT: {
                    if (isArray) {
                        String[] values = ((String)object).split(",");
                        short[] parsedValues = new short[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            parsedValues[i] = Short.parseShort(values[i]);
                        }
                        return parsedValues;
                    }
                    Short result = Short.parseShort((String)object);
                    return result;
                }
                case STRING: {
                    String[] values;
                    String[] result = isArray ? (values = ((String)object).split(",")) : (String[])object;
                    return result;
                }
            }
            return (String)object;
        }
        return object;
    }
}

