/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.issr.iet.weblogic.configuration;

import com.ibm.issr.iet.util.xml.XMLUtils;
import com.ibm.issr.iet.weblogic.beans.JMXBean;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeNotFoundException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class WSLMetadata {
    private static final String WLS_METADATA_LOCATION = "com/ibm/issr/iet/weblogic/configuration/wlsMetadata.xml";
    Map<String, JMXBean> supportedBeans = new ConcurrentHashMap<String, JMXBean>();
    private static WSLMetadata instance;

    public static void initialize(String metadataFile) throws ClassNotFoundException, AttributeNotFoundException, XPathExpressionException, IOException {
        boolean isResource = false;
        if (metadataFile == null || "".equals(metadataFile.trim())) {
            metadataFile = WSLMetadata.class.getClassLoader().getResource(WLS_METADATA_LOCATION).toString();
            if (metadataFile == null || "".equals(metadataFile.trim())) {
                throw new NullPointerException("WSLMetadata file name must not be empty");
            }
            isResource = true;
        }
        WSLMetadata.initialize(new File(metadataFile), isResource);
    }

    public static void initialize(File metadataFile, boolean isResource) throws ClassNotFoundException, AttributeNotFoundException, XPathExpressionException, IOException {
        if (instance == null) {
            instance = new WSLMetadata(metadataFile, isResource);
        }
    }

    private WSLMetadata(File metadataFile, boolean isResource) throws XPathExpressionException, ClassNotFoundException, AttributeNotFoundException, IOException {
        XMLUtils xmlUtils = new XMLUtils();
        Document metadataDom = null;
        metadataDom = isResource ? xmlUtils.loadDOMFromResource(WLS_METADATA_LOCATION, WSLMetadata.class.getClassLoader(), false) : xmlUtils.loadDOMFile(metadataFile, false);
        NodeList jmxBeanNodes = xmlUtils.xPathQuery(metadataDom, "jmxMetadata/jmxbean", NodeList.class);
        for (int i = 0; i < jmxBeanNodes.getLength(); ++i) {
            JMXBean bean = JMXBean.loadFromNode(jmxBeanNodes.item(i), xmlUtils);
            this.supportedBeans.put(bean.getName(), bean);
        }
        this.supportedBeans = Collections.unmodifiableMap(this.supportedBeans);
    }

    public JMXBean getJMXBean(String name) {
        JMXBean bean = this.supportedBeans.get(this.getBeanName(name));
        if (bean == null) {
            throw new IllegalArgumentException(name + " is not a supported data type");
        }
        return bean;
    }

    private String getBeanName(String name) {
        int arrayStart = name.indexOf(91);
        if (arrayStart > 0) {
            return name.substring(0, arrayStart);
        }
        return name.trim();
    }

    public static WSLMetadata getInstance() {
        if (instance == null) {
            throw new NullPointerException("WSL Metadata has not been initialized");
        }
        return instance;
    }
}

