/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.List;

public class WebLogicUtility {
    protected String getJavaCmd() throws IOException {
        File javaHome;
        String JAVA_HOME = System.getenv("JAVA_HOME");
        String javaCmd = "java";
        if (JAVA_HOME != null && (javaHome = new File(JAVA_HOME)).isDirectory()) {
            File binDir = new File(javaHome, "bin");
            if (binDir.isDirectory()) {
                javaCmd = new File(binDir, "java").getCanonicalPath();
            } else {
                File javaFile = new File(javaHome, "java");
                if (javaFile.isFile()) {
                    javaCmd = javaFile.getCanonicalPath();
                }
            }
        }
        return javaCmd;
    }

    protected void addAdditionalArgs(List<String> cmdArgs, String additionalArgs) {
        if (!StringUtil.isEmpty(additionalArgs)) {
            for (String argPair : additionalArgs.split("\n")) {
                String[] splitArgs;
                for (String splitArg : splitArgs = argPair.split(" ")) {
                    cmdArgs.add(splitArg);
                }
            }
        }
    }

    protected int runProcess(String processName, List<String> cmdArgs, String classpath) throws IOException {
        int returnCode = 0;
        System.out.println("Running " + processName + " Command:");
        for (String cmd : cmdArgs) {
            System.out.print(cmd + " ");
        }
        System.out.println("");
        ProcessBuilder builder = new ProcessBuilder(cmdArgs);
        builder.environment().put("CLASSPATH", classpath);
        Process process = builder.start();
        BufferedReader processInputStream = null;
        BufferedReader processErrorStream = null;
        try {
            String line;
            processInputStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
            processErrorStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = processInputStream.readLine()) != null) {
                System.out.println(line);
            }
            while ((line = processErrorStream.readLine()) != null) {
                System.out.println(line);
            }
            returnCode = process.waitFor();
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        if (returnCode != 0) {
            System.out.println("ERROR: Process exited with a non-zero exit code. Exiting failure");
        }
        return returnCode;
    }
}

