/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.WebLogicUtility;
import com.urbancode.commons.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class Deploy {
    private Properties inputProperties;
    private Properties outputProperties;

    public Deploy(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() throws IOException {
        WebLogicUtility util = new WebLogicUtility();
        String deploymentName = this.inputProperties.getProperty("name");
        String adminUrl = this.inputProperties.getProperty("adminurl");
        String username = this.inputProperties.getProperty("username");
        String password = this.inputProperties.getProperty("password");
        Boolean ssl = Boolean.valueOf(this.inputProperties.getProperty("ssl"));
        String targets = this.inputProperties.getProperty("targets");
        String source = this.inputProperties.getProperty("source");
        String classpath = this.inputProperties.getProperty("classpath");
        boolean nostage = Boolean.valueOf(this.inputProperties.getProperty("nostage"));
        boolean library = Boolean.valueOf(this.inputProperties.getProperty("library"));
        String additionalArgs = this.inputProperties.getProperty("additionalArgs");
        File sourceFile = new File(source);
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(util.getJavaCmd());
        cmdArgs.add("-Dweblogic.security.SSL.enableJSSE=" + ssl.toString());
        cmdArgs.add("weblogic.Deployer");
        cmdArgs.add("-adminurl");
        cmdArgs.add(adminUrl);
        cmdArgs.add("-username");
        cmdArgs.add(username);
        cmdArgs.add("-password");
        cmdArgs.add(password);
        cmdArgs.add("-deploy");
        cmdArgs.add("-source");
        cmdArgs.add(sourceFile.getAbsolutePath());
        if (StringUtil.isEmpty(deploymentName)) {
            System.out.println("No deployment name specified");
        } else {
            System.out.println("Running Deployment " + deploymentName);
            cmdArgs.add("-name");
            cmdArgs.add(deploymentName);
        }
        if (!StringUtil.isEmpty(targets)) {
            System.out.println("Specifying targets");
            cmdArgs.add("-targets");
            cmdArgs.add(targets);
        }
        if (nostage) {
            System.out.println("No Stage option specified");
            cmdArgs.add("-nostage");
        }
        if (library) {
            System.out.println("Library option specified");
            cmdArgs.add("-library");
        }
        util.addAdditionalArgs(cmdArgs, additionalArgs);
        return util.runProcess("Deploy", cmdArgs, classpath);
    }
}

