/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2015, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.powershell

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import com.urbancode.air.ExitCodeException
import org.apache.tools.ant.types.Commandline

class PSHelper {
    private ArrayList options
    private String powerShellHome
    private String powerShellScript
    private String successfulExitStatus
    private String inPropsFile
    private String outPropsFile
    private String runPowerShellScriptPath

    PSHelper (inProps, inPropsFile, outPropsFile, runPowerShellScriptPath) {
      this.options = splitOptions(inProps['options'])
      this.powerShellHome = inProps['powerShellHome']
      this.powerShellScript = inProps['powerShellScript']
      this.successfulExitStatus = inProps['successfulExitStatus']
      this.inPropsFile = inPropsFile
      this.outPropsFile = outPropsFile

      this.runPowerShellScriptPath = runPowerShellScriptPath
    }

    public executePowerShellScript() {
      ArrayList command = buildCommand()
      CommandHelper ch = new CommandHelper(new File("."))
      ch.setIgnoreExitValue(true)

      int exitValue = ch.runCommand('', command)
      System.exit(exitValue)
    }

    private ArrayList buildCommand() {
      ArrayList result = [powerShellHome]
      result.addAll(options)
      result.addAll(['-File', runPowerShellScriptPath,
      '-_IBMUCDPathToPluginInputPropsFile', inPropsFile,
      '-_IBMUCDPathToPluginOutputPropsFile', outPropsFile])
      return result
    }

    private ArrayList splitOptions(String options) {
      return Commandline.translateCommandline(options.trim())
    }
}
