/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2015, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.powershell

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.powershell.PSHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()
def exitStatus

// successful status must be stored to read in post processing script
apTool.setOutputProperty("successfulExitStatus", props['successfulExitStatus'])

try {
    PSHelper psHelper = new PSHelper(props, this.args[0], this.args[1], this.args[2])
    exitStatus = psHelper.executePowerShellScript()
}
finally {
    apTool.storeOutputProperties()
    System.exit(exitStatus)
}