/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2015, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.urbancode.air.plugin.powershell

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.powershell.PSHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()
def successfulExitStatus = props['successfulExitStatus']?.toInteger()
def exitStatus

try {
    PSHelper psHelper = new PSHelper(props, this.args[0], this.args[1], this.args[2])
    exitStatus = psHelper.executePowerShellScript()
    println("\n[OK] PowerShell script has completed execution with exit status: $exitStatus.")

    if (exitStatus != successfulExitStatus) {
        println("[Error] Exit status does not match successful exit status '$successfulExitStatus'.")
        println("[Possible Solution] Check the 'show hidden properties' box to change the successful status.")
    }
}
finally {
    System.exit(exitStatus)
}
