/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateParser {
    private final List<SimpleDateFormat> dateFormats = new ArrayList<SimpleDateFormat>(Arrays.asList(new SimpleDateFormat("E MMM dd HH:mm:ss zzz yyyy"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z"), new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy"), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SZ"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mmZ"), new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyyMMdd")));

    public void addDateFormat(SimpleDateFormat newFormat) {
        this.dateFormats.add(newFormat);
    }

    public List<String> getFormatPatterns() {
        ArrayList<String> result = new ArrayList<String>();
        for (SimpleDateFormat format : this.dateFormats) {
            result.add(format.toPattern());
        }
        return result;
    }

    public Date parseDate(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        try {
            return new Date(Long.valueOf(value));
        }
        catch (NumberFormatException e) {
            for (SimpleDateFormat format : this.dateFormats) {
                try {
                    return format.parse(value);
                }
                catch (ParseException pe) {
                }
            }
            throw new IllegalArgumentException("Unrecognized date format " + value);
        }
    }
}

