/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.Release;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class GitHubReleaseClient {
    private static final Logger log = Logger.getLogger(GitHubReleaseClient.class);
    private final String repoUrl;
    private final String githubUser;
    private final String githubPassword;
    private File tempDir;
    private Release latestRelease;

    public GitHubReleaseClient(String repoUrl, String githubUser, String githubPassword) throws IOException {
        this.repoUrl = repoUrl;
        this.githubUser = githubUser;
        this.githubPassword = githubPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Release getLatestVersion(String versionToImport) throws IOException {
        block16: {
            if (versionToImport != null) {
                System.out.println("Importing version: " + versionToImport);
            }
            String url = versionToImport == null ? "/releases/latest" : "/releases";
            try {
                URIBuilder uri = new URIBuilder(this.repoUrl + url);
                url = uri.build().toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Release URL is invalid: " + url, e);
            }
            this.latestRelease = new Release();
            HttpClient client = this.getHttpClient(this.githubUser, this.githubPassword);
            try {
                String base64Data = this.githubUser + ":" + this.githubPassword;
                HttpGet method = new HttpGet(url);
                byte[] encodedBytes = Base64.encodeBase64((byte[])base64Data.getBytes());
                method.setHeader("Accept", "application/json");
                method.setHeader("Authorization", "Basic " + new String(encodedBytes));
                HttpResponse response = client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    try {
                        int i;
                        String responseJson = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                        JSONObject releaseObject = new JSONObject();
                        if (versionToImport != null) {
                            boolean versionFound = false;
                            JSONArray releases = new JSONArray(responseJson);
                            for (i = 0; i < releases.length(); ++i) {
                                JSONObject release = releases.getJSONObject(i);
                                if (!release.get("tag_name").equals(versionToImport.trim())) continue;
                                releaseObject = release;
                                versionFound = true;
                            }
                            if (!versionFound) {
                                System.out.println("Version not found");
                                System.exit(1);
                            }
                        } else {
                            releaseObject = new JSONObject(responseJson);
                        }
                        this.latestRelease.setId(releaseObject.get("id").toString());
                        this.latestRelease.setTagName(releaseObject.get("tag_name").toString());
                        this.latestRelease.setVersionName(releaseObject.get("name").toString());
                        this.latestRelease.setTarballUrl(releaseObject.get("tarball_url").toString());
                        this.latestRelease.setZipballUrl(releaseObject.get("zipball_url").toString());
                        JSONArray assets = releaseObject.getJSONArray("assets");
                        String[] assetsUrls = new String[assets.length()];
                        for (i = 0; i < assets.length(); ++i) {
                            JSONObject asset = assets.getJSONObject(i);
                            assetsUrls[i] = asset.get("browser_download_url").toString();
                        }
                        this.latestRelease.setAssetsUrls(assetsUrls);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (this.latestRelease == null) {
                        throw new RuntimeException("[Error] Unable to parse GitHub Latest Release information.");
                    }
                    break block16;
                }
                System.out.println("[Info] HTTP Status Line: " + response.getStatusLine());
                throw new RuntimeException("[Error] Could not identify GitHub release: " + url);
            }
            finally {
                this.closeClient(client);
            }
        }
        return this.latestRelease;
    }

    public File downloadFiles(boolean tarball, boolean zipball) throws IOException {
        String[] downloadUrls;
        for (String url : downloadUrls = this.getDownloadUrls(tarball, zipball)) {
            this.download(url);
        }
        return this.getTempDir();
    }

    private File getTempDir() throws IOException {
        File result = this.tempDir;
        if (result == null) {
            this.tempDir = new File(UUID.randomUUID().toString());
            IO.mkdirs(this.tempDir);
            result = this.tempDir;
        }
        return result;
    }

    private void download(String fileURL) throws IOException {
        System.out.println("Asset downloading  :" + fileURL);
        URL url = new URL(fileURL);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 200) {
            String fileName = "";
            String disposition = httpConn.getHeaderField("Content-Disposition");
            if (disposition != null) {
                int index = disposition.indexOf("filename=");
                if (index > 0) {
                    fileName = disposition.substring(index + 9, disposition.length());
                }
            } else {
                fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1, fileURL.length());
            }
            File file = new File(this.getTempDir(), fileName);
            IO.copy(httpConn.getInputStream(), file);
            System.out.println("File downloaded");
        } else {
            System.out.println("No file to download. Server replied HTTP code: " + responseCode);
        }
        httpConn.disconnect();
    }

    private String[] getDownloadUrls(boolean tarball, boolean zipball) {
        int countForTarZipDownload = tarball && zipball ? 2 : (tarball || zipball ? 1 : 0);
        String[] result = new String[this.latestRelease.getAssetsUrls().length + countForTarZipDownload];
        int i = 0;
        for (String url : this.latestRelease.getAssetsUrls()) {
            result[i++] = url;
        }
        if (tarball) {
            result[i++] = this.latestRelease.getTarballUrl();
        }
        if (zipball) {
            result[i++] = this.latestRelease.getZipballUrl();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(InputStream in, File dest) throws IOException {
        ZipInputStream zin = new ZipInputStream(in);
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                File file = new File(dest, entry.getName());
                if (entry.isDirectory()) {
                    IO.mkdirs(file);
                } else {
                    IO.mkdirs(file.getParentFile());
                    IO.copy((InputStream)zin, file);
                }
                zin.closeEntry();
            }
        }
        finally {
            zin.close();
        }
    }

    public HttpClient getHttpClient(String user, String password) {
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTimeoutMillis(60000);
        builder.setTrustAllCerts(true);
        builder.setUsername(user);
        builder.setPassword(password);
        builder.setPreemptiveAuthentication(true);
        DefaultHttpClient result = builder.buildClient();
        return result;
    }

    public void closeClient(HttpClient client) {
        ClientConnectionManager connectionManager = client.getConnectionManager();
        connectionManager.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        connectionManager.shutdown();
    }
}

