/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.urbancode.commons.util.IO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private Comparator<Object> comparator = null;

    public SortedProperties() {
    }

    public SortedProperties(Properties defaults) {
        super.putAll((Map<?, ?>)defaults);
    }

    public void setComparator(Comparator<Object> comparator) {
        this.comparator = comparator;
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    public Set<Object> keySet() {
        TreeSet<Object> keySet = new TreeSet<Object>(this.comparator);
        keySet.addAll(super.keySet());
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(this.comparator);
        for (Map.Entry<Object, Object> entry : super.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableSet(map.entrySet());
    }

    public void store(Writer writer) throws IOException {
        this.store(writer, null);
    }

    public void store(OutputStream out) throws IOException {
        this.store(out, null);
    }

    @Override
    public void store(Writer writer, String comment) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        super.store(out, comment);
        InputStreamReader reader = IO.reader((InputStream)new ByteArrayInputStream(out.toByteArray()), IO.latin1());
        IO.copy((Reader)reader, writer);
    }
}

