/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.unix;

import com.urbancode.commons.util.Bits;

public final class ModeBits {
    public static final int SETUID = 2048;
    public static final int SETGID = 1024;
    public static final int STICKY = 512;
    public static final int USER_R = 256;
    public static final int USER_W = 128;
    public static final int USER_X = 64;
    public static final int GROUP_R = 32;
    public static final int GROUP_W = 16;
    public static final int GROUP_X = 8;
    public static final int OTHER_R = 4;
    public static final int OTHER_W = 2;
    public static final int OTHER_X = 1;

    public static boolean isSetUid(int mode) {
        return Bits.isSet(mode, 2048);
    }

    public static boolean isSetGid(int mode) {
        return Bits.isSet(mode, 1024);
    }

    public static boolean isSticky(int mode) {
        return Bits.isSet(mode, 512);
    }

    public static boolean isUserReadable(int mode) {
        return Bits.isSet(mode, 256);
    }

    public static boolean isUserWritable(int mode) {
        return Bits.isSet(mode, 128);
    }

    public static boolean isUserExecutable(int mode) {
        return Bits.isSet(mode, 64);
    }

    public static boolean isGroupReadable(int mode) {
        return Bits.isSet(mode, 32);
    }

    public static boolean isGroupWritable(int mode) {
        return Bits.isSet(mode, 16);
    }

    public static boolean isGroupExecutable(int mode) {
        return Bits.isSet(mode, 8);
    }

    public static boolean isOtherReadable(int mode) {
        return Bits.isSet(mode, 4);
    }

    public static boolean isOtherWritable(int mode) {
        return Bits.isSet(mode, 2);
    }

    public static boolean isOtherExecutable(int mode) {
        return Bits.isSet(mode, 1);
    }

    private ModeBits() {
        throw new UnsupportedOperationException();
    }
}

