/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.NexusClient;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ImportVersion {
    private NexusClient nexusClient;
    private ComponentClient componentClient;
    private VersionClient versionClient;
    private Properties inputProperties;
    private Properties outputProperties;
    private Logger logger;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
        this.logger = Logger.getLogger(this.getClass());
        String logLevel = inputProperties.getProperty("loggerLevel");
        Logger.getRootLogger().setLevel(Level.toLevel((String)logLevel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        int result = 0;
        try {
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String serverUrl = this.inputProperties.getProperty("serverUrl");
            String repo = this.inputProperties.getProperty("repo");
            String nexusComponent = this.inputProperties.getProperty("nexusComponent");
            String group = this.inputProperties.getProperty("group");
            String username = this.inputProperties.getProperty("user");
            String password = this.inputProperties.getProperty("password");
            String version = this.inputProperties.getProperty("version");
            boolean latest = Boolean.valueOf(this.inputProperties.getProperty("latest"));
            String charsetName = agentProps.getProperty("system.default.encoding");
            String ucdComponent = this.inputProperties.getProperty("componentName");
            boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
            String includesString = this.inputProperties.getProperty("includes");
            String[] includes = new String[]{};
            if (includesString != null) {
                if (includesString.trim().length() == 0) {
                    includesString = "**/*";
                }
                includes = includesString.split(",|\n");
                for (int i = 0; i < includes.length; ++i) {
                    includes[i] = includes[i].trim();
                }
            }
            String excludesString = this.inputProperties.getProperty("excludes");
            String[] excludes = new String[]{};
            if (excludesString != null) {
                excludes = excludesString.split(",|\n");
                for (int i = 0; i < excludes.length; ++i) {
                    excludes[i] = excludes[i].trim();
                }
            }
            String extensionString = this.inputProperties.getProperty("extensions");
            String[] extensions = new String[]{};
            if (extensionString != null) {
                extensions = extensionString.split(",");
                for (int i = 0; i < extensions.length; ++i) {
                    extensions[i] = extensions[i].trim();
                }
            }
            Charset charset = null;
            if (charsetName != null) {
                charset = Charset.forName(charsetName);
            }
            String ucdUser = "PasswordIsAuthToken";
            String ucdPass = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            URI ucdUrl = new URI(webUrl);
            this.nexusClient = new NexusClient(serverUrl, repo, username, password);
            this.versionClient = new VersionClient(ucdUrl, ucdUser, ucdPass);
            this.componentClient = new ComponentClient(ucdUrl, ucdUser, ucdPass);
            if (this.integrate(ucdComponent, nexusComponent, group, version, latest, isUseVFS, charset, extensions, includes, excludes) > 0) {
                this.logger.info((Object)"All versions have been successfully imported.");
            } else {
                this.logger.info((Object)"No new versions were found to import.");
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)String.format("Error Creating New Version: %s", ex.getMessage()), (Throwable)ex);
            result = 1;
        }
        finally {
            this.nexusClient.closeClient();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int integrate(String ucdComponent, String nexusComponent, String group, String version, boolean latest, boolean isUseVFS, Charset charset, String[] extensions, String[] includes, String[] excludes) throws Exception {
        File tempDir;
        int importCount;
        block15: {
            importCount = 0;
            tempDir = null;
            try {
                boolean saveExecuteBits = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
                List existingVersions = this.componentClient.getComponentVersions(ucdComponent, Boolean.valueOf(false));
                List archivedVersions = this.componentClient.getArchivedComponentVersions(ucdComponent);
                existingVersions.addAll(archivedVersions);
                Map<String, List<String>> assets = this.nexusClient.getAssets(version, group, nexusComponent);
                if (assets.size() > 0) {
                    assets.keySet().removeAll(existingVersions);
                    List<String> importVersions = this.nexusClient.sortVersions(assets.keySet());
                    if (importVersions.size() == 0) {
                        this.logger.info((Object)"All versions have already been imported.");
                    } else {
                        if (latest) {
                            this.logger.info((Object)"Importing only the latest version, based on Maven 3.0 version name conventions.");
                            String latestVersion = importVersions.get(importVersions.size() - 1);
                            importVersions = new ArrayList<String>();
                            importVersions.add(latestVersion);
                        }
                        this.logger.info((Object)("Creating new version(s): " + importVersions.toString()));
                        for (String importVersion : importVersions) {
                            Object versionId;
                            if (isUseVFS) {
                                tempDir = this.nexusClient.downloadFiles(importVersion, assets.get(importVersion));
                                versionId = this.versionClient.createAndAddVersionFiles(ucdComponent, importVersion, "", tempDir, "", includes, excludes, saveExecuteBits, false, charset, extensions);
                                this.outputProperties.setProperty("VersionID", ((UUID)versionId).toString());
                            } else {
                                versionId = this.versionClient.createVersion(ucdComponent, importVersion, " ").toString();
                                this.outputProperties.setProperty("VersionID", (String)versionId);
                            }
                            ++importCount;
                        }
                    }
                    break block15;
                }
                this.logger.info((Object)"No assets were found on the Nexus server with the given criteria.");
            }
            catch (Throwable throwable) {
                try {
                    if (tempDir != null && tempDir.exists()) {
                        IO.delete(tempDir);
                    }
                }
                catch (IOException ex) {
                    this.logger.error((Object)String.format("Unable to delete download directory", ex.getMessage(), ex));
                }
                throw throwable;
            }
        }
        try {
            if (tempDir != null && tempDir.exists()) {
                IO.delete(tempDir);
            }
        }
        catch (IOException ex) {
            this.logger.error((Object)String.format("Unable to delete download directory", ex.getMessage(), ex));
        }
        return importCount;
    }
}

