/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class NexusClient {
    private String serverUrl;
    private String repo;
    private String apiPath;
    private String repoFormat;
    private CloseableHttpClient client;
    private Map<String, File> tempDirs = new HashMap<String, File>();
    private Logger logger = Logger.getLogger(this.getClass());

    public NexusClient(String serverUrl, String repo, String username, String password) throws IOException {
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        if (!serverUrl.startsWith("http://") && !serverUrl.startsWith("https://")) {
            serverUrl = "http://" + serverUrl;
        }
        this.serverUrl = serverUrl;
        this.repo = repo;
        this.client = this.getHttpClient(username, password);
        this.apiPath = this.getApiPath();
    }

    public File downloadFiles(String version, List<String> downloadUrls) throws IOException, JSONException {
        this.logger.info((Object)("Downloading files for version '" + version + "'."));
        for (String downloadUrl : downloadUrls) {
            this.download(version, downloadUrl);
        }
        return this.getTempDir(version);
    }

    public Map<String, List<String>> getAssets(String version, String group, String nexusComponent) throws IOException, JSONException {
        String path = this.getAbsoluteUrl("/search") + "?repository=" + this.encodePath(this.repo);
        HashMap<String, List<String>> assetMap = new HashMap<String, List<String>>();
        String message = "Searching for assets with the given criteria: repository= '" + this.repo + "'";
        if (version != null && !version.isEmpty()) {
            if (!"raw".equals(this.repoFormat)) {
                path = path + "&version=" + this.encodePath(version);
            }
            message = message + ", version='" + version + "'";
        }
        if (group != null && !group.isEmpty()) {
            message = message + ", group='" + group + "'";
            path = path + "&group=" + this.encodePath(group);
        }
        if (nexusComponent != null && !nexusComponent.isEmpty()) {
            message = message + ", component='" + nexusComponent + "'";
        }
        this.logger.info((Object)(message + "."));
        String nextPage = null;
        do {
            JSONObject jsonObject = null;
            CloseableHttpResponse response = null;
            response = nextPage != null && !"null".equals(nextPage) ? this.doGet(path + "&continuationToken=" + nextPage) : this.doGet(path);
            jsonObject = this.getJSONFromResponse(response);
            if (jsonObject == null || jsonObject.length() <= 0) continue;
            nextPage = jsonObject.getString("continuationToken");
            JSONArray items = jsonObject.getJSONArray("items");
            for (int i = 0; i < items.length(); ++i) {
                JSONObject item = items.getJSONObject(i);
                if (nexusComponent != null && !nexusComponent.isEmpty()) {
                    this.logger.debug((Object)("Ignoring asset which is not part of specified Nexus component '" + nexusComponent + "': " + System.lineSeparator() + item.toString()));
                    String componentName = item.getString("name");
                    if (!componentName.equals(nexusComponent)) continue;
                }
                JSONArray assets = item.getJSONArray("assets");
                String itemVersion = item.getString("version");
                if ("null".equals(itemVersion)) {
                    itemVersion = this.getRootDir(item.getString("group"));
                    if (version != null && !version.isEmpty() && !version.equals(itemVersion)) continue;
                }
                for (int j = 0; j < assets.length(); ++j) {
                    JSONObject asset = assets.getJSONObject(j);
                    String downloadUrl = asset.getString("downloadUrl");
                    List downloadUrls = null;
                    downloadUrls = assetMap.containsKey(itemVersion) ? (List)assetMap.get(itemVersion) : new ArrayList();
                    downloadUrls.add(downloadUrl);
                    assetMap.put(itemVersion, downloadUrls);
                }
            }
        } while (nextPage != null && !"null".equals(nextPage));
        this.logger.info((Object)("Found version(s): " + assetMap.keySet() + " from Nexus server."));
        return assetMap;
    }

    public List<String> sortVersions(Set<String> versions) {
        Comparator<String> sortByVersion = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                ComparableVersion v1 = new ComparableVersion(o1);
                ComparableVersion v2 = new ComparableVersion(o2);
                return v1.compareTo(v2);
            }
        };
        TreeSet<String> sortedVersions = new TreeSet<String>(sortByVersion);
        sortedVersions.addAll(versions);
        return new ArrayList<String>(sortedVersions);
    }

    public void closeClient() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException ex) {
                this.logger.warn((Object)"Failed to close HTTP client.", (Throwable)ex);
            }
        }
    }

    private CloseableHttpClient getHttpClient(String username, String password) {
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTimeoutMillis(60000);
        builder.setTrustAllCerts(true);
        if (!StringUtils.isEmpty((CharSequence)username)) {
            builder.setUsername(username);
            builder.setPassword(password);
            builder.setPreemptiveAuthentication(true);
        }
        DefaultHttpClient result = builder.buildClient();
        return result;
    }

    private String getApiPath() throws IOException {
        String v1ApiPath = "/service/rest/v1";
        if (this.setRepoFormat(v1ApiPath)) {
            this.logger.info((Object)"Successfully connected to Nexus 3 V1 REST API (latest).");
            return v1ApiPath;
        }
        String betaApiPath = "/service/rest/beta";
        String siestaApiPath = "/service/siesta/api/v1";
        this.logger.warn((Object)"This Nexus server is an outdated version. It is recommended to upgrade to version 3.13 or greater.");
        if (this.setRepoFormat(betaApiPath)) {
            this.logger.info((Object)"Successfully connected to Nexus 3 BETA REST API (outdated).");
            return betaApiPath;
        }
        if (this.setRepoFormat(siestaApiPath)) {
            this.logger.info((Object)"Successfully connected to Nexus 3 SIESTA REST API (outdated).");
            return siestaApiPath;
        }
        throw new RuntimeException("Failed to connect to any valid Nexus 3 REST API paths.  Please ensure that your Nexus server is at least version 3.0.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRepoFormat(String apiPath) throws IOException {
        String repoEndpoint = this.serverUrl + apiPath + "/repositories";
        HttpGet method = new HttpGet(repoEndpoint);
        CloseableHttpResponse response = null;
        JSONArray jsonArray = null;
        try {
            method.setHeader("Accept", "application/json");
            response = this.doGet(repoEndpoint);
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                HttpEntity entity = response.getEntity();
                try {
                    String json = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    jsonArray = new JSONArray(json);
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String format;
                        JSONObject repository = jsonArray.getJSONObject(i);
                        String name = repository.getString("name");
                        if (!this.repo.equals(name)) continue;
                        this.repoFormat = format = repository.getString("format");
                    }
                }
                catch (IOException ex) {
                    this.logger.warn((Object)"Failed to acquire repository format:", (Throwable)ex);
                }
                catch (JSONException ex) {
                    this.logger.warn((Object)"Failed to acquire repository format:", (Throwable)ex);
                }
                boolean bl = true;
                this.closeResponse(response);
                return bl;
            }
            this.closeResponse(response);
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
        return false;
    }

    private void closeResponse(CloseableHttpResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException ex) {
                this.logger.warn((Object)"Failed to close HTTP response.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String version, String url) throws ClientProtocolException, IOException {
        block7: {
            HttpGet method = new HttpGet(url);
            this.logger.info((Object)("Downloading file from URL '" + url + "'."));
            CloseableHttpResponse response = null;
            try {
                response = this.client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    String filename = null;
                    if (response.containsHeader("Content-Disposition")) {
                        Header responseHeader = response.getFirstHeader("Content-Disposition");
                        for (HeaderElement element : responseHeader.getElements()) {
                            filename = element.getParameterByName("filename").getValue();
                        }
                    } else {
                        filename = this.getFileName(url);
                    }
                    File file = null;
                    file = new File(this.getTempDir(version), filename);
                    IO.copy(response.getEntity().getContent(), file);
                    this.logger.debug((Object)("Copied file to temporary directory '" + file.getAbsolutePath() + "'."));
                    break block7;
                }
                throw new HttpResponseException(status, "HTTP request to url: " + url + " failed with status: " + status);
            }
            finally {
                this.closeResponse(response);
            }
        }
    }

    private File getTempDir(String version) throws IOException {
        File result = this.tempDirs.get(version);
        if (result == null) {
            result = new File(System.getProperty("user.dir"), UUID.randomUUID().toString());
            IO.mkdirs(result);
            this.tempDirs.put(version, result);
        }
        return result;
    }

    private CloseableHttpResponse doGet(String path) throws IOException {
        HttpGet getRequest = new HttpGet(path);
        CloseableHttpResponse response = null;
        Object jsonObject = null;
        getRequest.setHeader("Accept", "application/json");
        response = this.client.execute((HttpUriRequest)getRequest);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getJSONFromResponse(CloseableHttpResponse response) throws JSONException, IOException {
        JSONObject jsonObject = null;
        int status = response.getStatusLine().getStatusCode();
        try {
            if (status == 200) {
                HttpEntity entity = response.getEntity();
                String json = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                jsonObject = new JSONObject(json);
            }
        }
        finally {
            this.closeResponse(response);
        }
        return jsonObject;
    }

    private String getAbsoluteUrl(String endpoint) {
        if (!endpoint.startsWith("/")) {
            endpoint = '/' + endpoint;
        }
        return this.serverUrl + this.apiPath + endpoint;
    }

    private String encodePath(String path) throws UnsupportedEncodingException {
        return URLEncoder.encode(path, "UTF-8");
    }

    private String getFileName(String url) {
        int index = url.lastIndexOf(47);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid file URL '" + url + "'.");
        }
        String result = url.substring(index + 1);
        if (result.length() == 0) {
            throw new IllegalArgumentException("Invalid file URL '" + url + "'.");
        }
        return result;
    }

    private String getRootDir(String filePath) {
        int index;
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(filePath.indexOf("/") + 1);
        }
        if ((index = filePath.indexOf("/")) == -1) {
            throw new IllegalArgumentException("Invalid file path '" + filePath + "'.");
        }
        String result = filePath.substring(0, index);
        if (result.length() == 0) {
            throw new IllegalArgumentException("Invalid file path '" + filePath + "'.");
        }
        return result;
    }
}

