/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntStylePatternMatcher {
    private static int MATCH_ALL = 0;
    private static int MATCH_CURRENT = 1;
    private static int MATCH_EXACT = 2;
    private static int DIRECTORY = 3;
    private final List<List<PatternNode>> includeNodesList = new ArrayList<List<PatternNode>>();
    private final List<List<PatternNode>> excludeNodesList;
    private final boolean excludeOverride = true;

    public AntStylePatternMatcher(String[] includes, String[] excludes) {
        if (includes != null) {
            for (String include : includes) {
                this.includeNodesList.add(this.getPatternNodes(include));
            }
        }
        this.excludeNodesList = new ArrayList<List<PatternNode>>();
        if (excludes != null) {
            for (String exclude : excludes) {
                this.excludeNodesList.add(this.getPatternNodes(exclude));
            }
        }
    }

    public boolean accept(String value) {
        boolean result = true;
        if (this.includeNodesList.size() > 0) {
            result = false;
            for (List<PatternNode> includeNodes : this.includeNodesList) {
                try {
                    if (!this.match(value, includeNodes)) continue;
                    result = true;
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        if (result && this.excludeNodesList.size() > 0) {
            for (List<PatternNode> excludeNodes : this.excludeNodesList) {
                try {
                    if (!this.match(value, excludeNodes)) continue;
                    result = false;
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        return result;
    }

    private List<PatternNode> getPatternNodes(String string) {
        ArrayList<PatternNode> nodes = new ArrayList<PatternNode>();
        string = string.replace('\\', File.separatorChar);
        string = string.replace('/', File.separatorChar);
        StringTokenizer tokenizer = new StringTokenizer(string, File.separator, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("**")) {
                nodes.add(new PatternNode(null, MATCH_ALL));
                continue;
            }
            if (token.indexOf("*") >= 0) {
                StringTokenizer subtokenizer = new StringTokenizer(token, "*", true);
                while (subtokenizer.hasMoreTokens()) {
                    String subtoken = subtokenizer.nextToken();
                    if (subtoken.equals("*")) {
                        nodes.add(new PatternNode(null, MATCH_CURRENT));
                        continue;
                    }
                    nodes.add(new PatternNode(subtoken, MATCH_EXACT));
                }
                continue;
            }
            if (token.equals(File.separator)) {
                nodes.add(new PatternNode(token, DIRECTORY));
                continue;
            }
            nodes.add(new PatternNode(token, MATCH_EXACT));
        }
        return nodes;
    }

    private boolean match(String value, List<PatternNode> nodes) throws Exception {
        return this.match(value, nodes, 0, 0);
    }

    private boolean match(String value, List<PatternNode> nodes, int nameIndex, int nodeIndex) throws Exception {
        PatternNode currentNode = nodes.get(nodeIndex);
        if (currentNode.getType() == MATCH_ALL) {
            PatternNode nextNode;
            if ((nextNode = nodes.get(++nodeIndex)) == null || nextNode.getType() != DIRECTORY) {
                throw new Exception("Matching statement not formatted correctly.");
            }
            boolean test = this.match(value, nodes, nameIndex, ++nodeIndex);
            while (!test && value.indexOf(nextNode.getMatch(), nameIndex) >= 0) {
                nameIndex = value.indexOf(nextNode.getMatch(), nameIndex) + nextNode.getMatch().length();
                test = this.match(value, nodes, nameIndex, nodeIndex);
            }
            return test;
        }
        if (currentNode.getType() == MATCH_CURRENT) {
            PatternNode nextNode;
            if (nodeIndex == nodes.size() - 1) {
                return value.indexOf(File.separator, nameIndex) < 0 && value.length() > nameIndex;
            }
            ++nameIndex;
            if ((nextNode = nodes.get(++nodeIndex)).getType() == DIRECTORY) {
                nameIndex = value.indexOf(nextNode.getMatch(), nameIndex);
                if (nameIndex > 0) {
                    return this.match(value, nodes, nameIndex, nodeIndex);
                }
                return false;
            }
            if (nextNode.getType() == MATCH_EXACT) {
                int limitIndex = value.indexOf(File.separator, nameIndex);
                if (limitIndex < 0) {
                    limitIndex = value.length();
                }
                if ((nameIndex = value.indexOf(nextNode.getMatch(), nameIndex)) > 0 && nameIndex < limitIndex) {
                    boolean test = this.match(value, nodes, nameIndex, nodeIndex);
                    while (!test && value.indexOf(nextNode.getMatch(), ++nameIndex) >= 0 && value.indexOf(nextNode.getMatch(), nameIndex) < limitIndex) {
                        nameIndex = value.indexOf(nextNode.getMatch(), nameIndex);
                        test = this.match(value, nodes, nameIndex, nodeIndex);
                    }
                    return test;
                }
                return false;
            }
            throw new Exception("Matching statement not formatted correctly.");
        }
        if (currentNode.getType() == DIRECTORY) {
            if (value.substring(nameIndex++, nameIndex).equals(currentNode.getMatch())) {
                return this.match(value, nodes, nameIndex, ++nodeIndex);
            }
            return false;
        }
        if (value.length() < nameIndex + currentNode.getMatch().length()) {
            return false;
        }
        if (value.substring(nameIndex, nameIndex + currentNode.getMatch().length()).equals(currentNode.getMatch())) {
            if (nodeIndex == nodes.size() - 1) {
                return nameIndex + currentNode.getMatch().length() == value.length();
            }
            return this.match(value, nodes, nameIndex + currentNode.getMatch().length(), ++nodeIndex);
        }
        return false;
    }

    private static class PatternNode {
        private String match;
        private int type;

        PatternNode(String match, int type) {
            this.match = match;
            this.type = type;
        }

        String getMatch() {
            return this.match;
        }

        int getType() {
            return this.type;
        }
    }
}

