/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.npm.rest;

import com.urbancode.air.plugin.PluginExecutionException;
import com.urbancode.commons.httpcomponentsutil.CloseableHttpClientBuilder;
import java.io.IOException;
import org.apache.commons.lang.math.IntRange;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class NPMRestClient {
    final String AUTH_ENDPOINT = "/-/user/org.couchdb.user:%s";
    final IntRange SUCCESS_RANGE = new IntRange(100, 300);
    private CloseableHttpClient client;
    String registryUrl;
    String username;
    String password;

    public NPMRestClient(String registryUrl, String username, String password) throws PluginExecutionException {
        if (!registryUrl.toLowerCase().startsWith("http://") && !registryUrl.toLowerCase().startsWith("https://")) {
            throw new PluginExecutionException("Missing HTTP protocol (http:// or https://) on registry URL: ${registryUrl}");
        }
        this.registryUrl = registryUrl;
        this.username = username;
        this.password = password;
        this.client = this.getHttpClient(username, password);
    }

    public String getAuthToken() throws PluginExecutionException, IOException, JSONException {
        String url = this.getAbsoluteUrl(String.format("/-/user/org.couchdb.user:%s", this.username));
        HttpPut putRequest = new HttpPut(url);
        putRequest.addHeader("Accept", "application/json");
        putRequest.addHeader("Content-Type", "application/json");
        JSONObject entity = new JSONObject();
        entity.put("name", (Object)this.username);
        entity.put("password", (Object)this.password);
        JSONObject responseEntity = new JSONObject(this.doPutRequest(putRequest, entity));
        String authToken = responseEntity.getString("token");
        return authToken;
    }

    private CloseableHttpClient getHttpClient(String username, String password) {
        CloseableHttpClientBuilder builder = new CloseableHttpClientBuilder();
        builder.setTimeoutMillis(60000);
        builder.setTrustAllCerts(true);
        if (!StringUtils.isEmpty((CharSequence)username)) {
            builder.setUsername(username);
            builder.setPassword(password);
            builder.setPreemptiveAuthentication(true);
        }
        CloseableHttpClient result = builder.buildClient();
        return result;
    }

    protected String doPutRequest(HttpPut request, JSONObject entity) throws PluginExecutionException, IOException {
        CloseableHttpResponse response;
        StatusLine statusLine;
        int statusCode;
        if (entity != null) {
            request.setEntity((HttpEntity)new StringEntity(entity.toString()));
        }
        if (!this.SUCCESS_RANGE.containsNumber((Number)(statusCode = (statusLine = (response = this.client.execute((HttpUriRequest)request)).getStatusLine()).getStatusCode()))) {
            throw new PluginExecutionException("HTTP request failed with a response code of " + statusCode + ":" + statusLine.getReasonPhrase() + ".");
        }
        HttpEntity responseEntity = response.getEntity();
        String responseBody = EntityUtils.toString((HttpEntity)responseEntity);
        return responseBody;
    }

    private String getAbsoluteUrl(String endpoint) {
        if (this.registryUrl.endsWith("/")) {
            return this.registryUrl.substring(0, this.registryUrl.length() - 1) + endpoint;
        }
        return this.registryUrl + endpoint;
    }
}

