/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.PluginExecutionException;
import com.urbancode.air.plugin.npm.cli.NPMCLIHelper;
import com.urbancode.air.plugin.npm.rest.NPMRestClient;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;

public class ImportVersion {
    private NPMCLIHelper cliHelper;
    private ComponentClient componentClient;
    private VersionClient versionClient;
    private Properties inputProperties;
    private Properties outputProperties;
    private Logger logger;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
        this.logger = Logger.getLogger(this.getClass());
        String logLevel = inputProperties.getProperty("loggerLevel");
        Logger.getRootLogger().setLevel(Level.toLevel((String)logLevel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws IOException, InterruptedException, URISyntaxException, JSONException {
        int result = 0;
        try {
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String registryUrl = this.inputProperties.getProperty("registryUrl").trim();
            String username = this.trimInput(this.inputProperties.getProperty("username"));
            String password = this.trimInput(this.inputProperties.getProperty("password"));
            String pkg = this.inputProperties.getProperty("package").trim();
            String cliPath = this.trimInput(this.inputProperties.getProperty("cliPath"));
            boolean allVersions = Boolean.valueOf(this.inputProperties.getProperty("allVersions"));
            String version = this.trimInput(this.inputProperties.getProperty("version"));
            String charsetName = agentProps.getProperty("system.default.encoding");
            String component = this.trimInput(this.inputProperties.getProperty("componentName"));
            boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
            Charset charset = null;
            if (charsetName != null) {
                charset = Charset.forName(charsetName);
            }
            try {
                NPMRestClient restClient = new NPMRestClient(registryUrl, username, password);
                this.cliHelper = new NPMCLIHelper(cliPath);
                String scope = null;
                if (pkg.startsWith("@")) {
                    scope = pkg.substring(pkg.indexOf("@") + 1, pkg.indexOf("/"));
                    this.cliHelper.configureScope(registryUrl, scope);
                }
                if (username != null && !username.isEmpty() && password != null && !password.isEmpty()) {
                    String authToken = restClient.getAuthToken();
                    this.cliHelper.authenticate(registryUrl, authToken);
                }
            }
            catch (PluginExecutionException ex) {
                this.logger.error((Object)("Failed to authenticate with registry: " + ex.getMessage()));
                int scope = 1;
                try {
                    if (this.cliHelper != null) {
                        this.cliHelper.logout();
                    }
                }
                catch (PluginExecutionException ex2) {
                    this.logger.warn((Object)("Failed to logout of registry: " + ex2.getMessage()));
                }
                return scope;
            }
            String ucdUser = "PasswordIsAuthToken";
            String ucdPass = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            URI ucdUrl = new URI(webUrl);
            this.versionClient = new VersionClient(ucdUrl, ucdUser, ucdPass);
            this.componentClient = new ComponentClient(ucdUrl, ucdUser, ucdPass);
            ArrayList<String> importVersions = new ArrayList<String>();
            if (version != null && version.trim().length() > 0) {
                importVersions.add(version);
            } else {
                try {
                    if (allVersions) {
                        importVersions = this.cliHelper.getAllVersions(pkg);
                    } else {
                        importVersions.add(this.cliHelper.getLatestVersion(pkg));
                    }
                }
                catch (PluginExecutionException ex) {
                    this.logger.error((Object)("Failed to get package versions: " + ex.getMessage()));
                    int n = 1;
                    try {
                        if (this.cliHelper != null) {
                            this.cliHelper.logout();
                        }
                    }
                    catch (PluginExecutionException ex3) {
                        this.logger.warn((Object)("Failed to logout of registry: " + ex3.getMessage()));
                    }
                    return n;
                }
            }
            try {
                if (this.integrate(component, pkg, importVersions, isUseVFS, charset) > 0) {
                    this.logger.info((Object)"All versions have been successfully imported.");
                } else {
                    this.logger.info((Object)"No new versions were found to import.");
                }
            }
            catch (PluginExecutionException ex) {
                this.logger.error((Object)("Failed to import versions: " + ex.getMessage()));
                int n = 1;
                try {
                    if (this.cliHelper != null) {
                        this.cliHelper.logout();
                    }
                }
                catch (PluginExecutionException ex4) {
                    this.logger.warn((Object)("Failed to logout of registry: " + ex4.getMessage()));
                }
                return n;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Error Creating New Versions: " + ex.getMessage()), (Throwable)ex);
            result = 1;
        }
        finally {
            try {
                if (this.cliHelper != null) {
                    this.cliHelper.logout();
                }
            }
            catch (PluginExecutionException ex) {
                this.logger.warn((Object)("Failed to logout of registry: " + ex.getMessage()));
            }
        }
        return result;
    }

    public int integrate(String component, String pkg, List<String> importVersions, boolean isUseVFS, Charset charset) throws Exception {
        int imported = 0;
        boolean saveExecuteBits = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
        List existingVersions = this.componentClient.getComponentVersions(component, Boolean.valueOf(false));
        List archivedVersions = this.componentClient.getArchivedComponentVersions(component);
        existingVersions.addAll(archivedVersions);
        importVersions.removeAll(existingVersions);
        if (importVersions.size() > 0) {
            this.logger.info((Object)("New version(s) to import: " + importVersions.toString()));
            ArrayList<String> versionIds = new ArrayList<String>();
            for (String importVersion : importVersions) {
                if (isUseVFS) {
                    File tempDir = this.cliHelper.downloadPackage(pkg, importVersion);
                    String[] includes = new String[]{"**/*"};
                    String[] excludes = new String[]{};
                    this.logger.info((Object)("Creating new version(s): " + importVersions.toString() + " and uploading files to VFS"));
                    UUID versionId = this.versionClient.createAndAddVersionFiles(component, importVersion, "", tempDir, "", includes, excludes, saveExecuteBits, true, charset, null);
                    versionIds.add(versionId.toString());
                } else {
                    this.logger.info((Object)("Creating new version(s): " + importVersions.toString()));
                    String versionId = this.versionClient.createVersion(component, importVersion, " ", true).toString();
                    this.versionClient.markImportFinished(component, versionId);
                    this.logger.info((Object)"Not uploading version(s) to VFS since the Copy To CodeStation box was not selected.");
                    versionIds.add(versionId.toString());
                }
                ++imported;
            }
            if (versionIds.size() > 1) {
                this.outputProperties.setProperty("VersionIDs", StringUtils.join(versionIds, (String)" "));
            } else if (versionIds.size() == 0) {
                this.outputProperties.setProperty("VersionID", (String)versionIds.get(0));
            }
        }
        return imported;
    }

    private String trimInput(String input) {
        if (input != null) {
            input = input.trim();
        }
        return input;
    }
}

