/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.npm.cli;

import com.urbancode.air.plugin.PluginExecutionException;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;

public class NPMCLIHelper {
    private Map<String, File> tempDirs = new HashMap<String, File>();
    private String npmCLIPath;
    private String authKey;
    private Logger logger = Logger.getLogger(this.getClass());

    public NPMCLIHelper(String npmCLIPath) throws PluginExecutionException {
        if (npmCLIPath != null && !npmCLIPath.isEmpty()) {
            File npmFile = new File(npmCLIPath);
            if (!npmFile.exists() || !npmFile.isFile()) {
                throw new PluginExecutionException("Invalid NPM executable path: " + npmCLIPath);
            }
            this.npmCLIPath = npmCLIPath;
        } else {
            this.npmCLIPath = "npm";
        }
    }

    public void authenticate(String registryUrl, String authToken) throws IOException, PluginExecutionException, InterruptedException {
        this.authKey = "//" + registryUrl + ":/_authToken";
        List<String> cmdArgs = Arrays.asList(this.npmCLIPath, "set", this.authKey, authToken);
        this.runCommand(cmdArgs);
    }

    public void configureScope(String registryUrl, String scope) throws IOException, PluginExecutionException, InterruptedException {
        String scopeKey = "@" + scope + ":registry";
        List<String> cmdArgs = Arrays.asList(this.npmCLIPath, "set", scopeKey, registryUrl);
        this.runCommand(cmdArgs);
    }

    public void logout() throws IOException, PluginExecutionException, InterruptedException {
        if (this.authKey != null) {
            List<String> cmdArgs = Arrays.asList(this.npmCLIPath, "config", "delete", this.authKey);
            this.runCommand(cmdArgs);
        }
    }

    public List<String> getAllVersions(String pkg) throws JSONException, IOException, PluginExecutionException, InterruptedException {
        ArrayList<String> versions = new ArrayList<String>();
        List<String> cmdArgs = Arrays.asList(this.npmCLIPath, "view", pkg, "versions", "--json");
        JSONArray jsonArr = new JSONArray(this.runCommand(cmdArgs));
        for (int i = 0; i < jsonArr.length(); ++i) {
            String version = jsonArr.getString(i);
            versions.add(this.sanitizeVersion(version));
        }
        return versions;
    }

    public String getLatestVersion(String pkg) throws IOException, PluginExecutionException, InterruptedException {
        List<String> cmdArgs = Arrays.asList(this.npmCLIPath, "view", pkg, "version");
        String output = this.runCommand(cmdArgs);
        return this.sanitizeVersion(output);
    }

    public File downloadPackage(String pkg, String version) throws IOException, PluginExecutionException, InterruptedException {
        List<String> cmdArgs = Arrays.asList(this.npmCLIPath, "pack", pkg + "@" + version);
        File tempDir = this.getTempDir(version);
        this.runCommand(cmdArgs, tempDir);
        return tempDir;
    }

    private String runCommand(List<String> cmdArgs) throws IOException, PluginExecutionException, InterruptedException {
        return this.runCommand(cmdArgs, new File("."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runCommand(List<String> cmdArgs, File workDir) throws IOException, PluginExecutionException, InterruptedException {
        this.logger.info((Object)("Running command: " + StringUtils.join(cmdArgs, (String)" ")));
        ProcessBuilder pb = new ProcessBuilder(cmdArgs);
        pb.directory(workDir);
        Thread shutdownHook = null;
        InputStream inputStream = null;
        InputStream errorStream = null;
        String output = "";
        Process process = pb.start();
        try {
            shutdownHook = this.addShutdownHook(process);
            process.waitFor();
            process.getOutputStream().close();
            inputStream = process.getInputStream();
            output = IOUtils.toString((InputStream)inputStream, null);
            if (process.exitValue() != 0) {
                errorStream = process.getErrorStream();
                String error = IOUtils.toString((InputStream)errorStream, null);
                if (error == null || error.isEmpty()) {
                    error = output;
                }
                throw new PluginExecutionException("NPM command failed with error: " + error);
            }
            if (output != null && !output.isEmpty()) {
                String indentOutput = output.replaceAll("(?m)^", "    ");
                this.logger.info((Object)("NPM Command Line Output: " + System.lineSeparator() + indentOutput));
            }
        }
        finally {
            try {
                inputStream.close();
                if (errorStream != null) {
                    errorStream.close();
                }
            }
            catch (IOException iOException) {}
            process.destroy();
            if (shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
        }
        return output;
    }

    private Thread addShutdownHook(final Process process) {
        Thread closeChild = new Thread(){

            @Override
            public void run() {
                process.destroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(closeChild);
        return closeChild;
    }

    private File getTempDir(String version) throws IOException {
        File result = this.tempDirs.get(version);
        if (result == null) {
            result = new File(System.getProperty("user.dir"), UUID.randomUUID().toString());
            IO.mkdirs(result);
            this.tempDirs.put(version, result);
        }
        this.logger.debug((Object)("Temporary directory for version " + version + ": " + result.getAbsolutePath()));
        return result;
    }

    private String sanitizeVersion(String input) {
        return input.replaceAll("\\p{Cntrl}", "");
    }
}

