/*
* Licensed Materials - Property of HCL
* UrbanCode Deploy
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.sybase.ISQLCmdHelper

AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
Properties props = apTool.getStepProperties()

String isqlPath = props["isqlPath"]
String sybaseProfile = props["sybaseProfile"]?.trim()
String username = props["username"]
String password = props["password"]
String server = props["server"]
String database = props["database"]
String failure = props["failure"]
List<String> additionalArgs = props["additionalArgs"]?.tokenize("\n")*.trim()
String defaultShell = props["shell"]?.trim()

if (!apTool.isWindows) {
    if (defaultShell) {
        if (!(new File(defaultShell)).exists()) {
            defaultShell = System.getenv("SHELL")
        }
    }
}
else {
    defaultShell = ""
}

File isqlCommand = new File(isqlPath)

if (!isqlCommand.isFile()) {
    throw new FileNotFoundException("'${isqlPath}' does not exist or is not a file.")
}

if (sybaseProfile) {
    File sybaseFile = new File(sybaseProfile)
    if (sybaseFile.isFile()) {
        println("[OK] ${sybaseProfile} will be sourced before executing SQL files.")
    }
    else {
        println("[WARNING] SYBASE.sh file ${sybaseProfile} does not exist and will not be sourced.")
        sybaseProfile = ""
    }
}

ISQLCmdHelper isqlHelper = new ISQLCmdHelper(
    isqlCommand,
    sybaseProfile,
    username,
    password,
    server,
    database,
    failure,
    additionalArgs,
    defaultShell)

def fileStrings = props["sqlFiles"]?.tokenize("\n")*.trim()
def sqlFiles = [] // ArrayList of SQL files to run against the DB

for (String fileString in fileStrings) {
    File file = new File(fileString)

    /* Check if path exists and if it's a file */
    if (file.isFile()) {
        String filename = file.getName()
        String extension = filename.substring(filename.lastIndexOf(".") + 1)

        /* Add SQL file to run or parse control file for SQL files */
        if (extension.toLowerCase().equals("sql")) {
            sqlFiles << file
        }
        else {
            sqlFiles.addAll(parseControlFile(file))
        }
    }
    else {
        throw new FileNotFoundException("'${fileString}' does not exist or is not a file.")
    }
}

int status = isqlHelper.runSQLFiles(sqlFiles)

System.exit(status)

/* Parse through text of a control file to attain SQL files */
private List<File> parseControlFile(File controlFile) {
    String controlText = controlFile.getText("UTF-8")
    List<File> innerSQLFiles = []

    for (String path in controlText.tokenize("\n")*.trim()) {
        File sqlFile = new File(path)

        innerSQLFiles << sqlFile
    }

    return innerSQLFiles
}