/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.client.cache;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.vfs.client.cache.CacheStagingFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.UUID;
import org.apache.log4j.Logger;

public class Cache {
    private static Logger log = Logger.getLogger(Cache.class);
    private final File blobsDir;
    private final File tempDir;

    public static Cache getUserCache() throws IOException {
        File home = new File(System.getProperty("user.home"));
        File cacheDir = new File(home, ".vfs-cache");
        return new Cache(cacheDir);
    }

    public Cache(File cacheDir) throws IOException {
        Check.nonNull((Object)cacheDir, (String)"cacheDir");
        this.blobsDir = new File(cacheDir, "blobs");
        this.tempDir = new File(cacheDir, "temp");
    }

    public boolean isCached(byte[] identifier) {
        Check.nonNull((Object)identifier, (String)"identifier");
        byte[] hash = this.hashIdentifier(identifier);
        boolean result = this.getBlobFile(hash).isFile();
        return result;
    }

    public InputStream get(byte[] identifier) {
        Check.nonNull((Object)identifier, (String)"identifier");
        FileInputStream result = null;
        byte[] hash = this.hashIdentifier(identifier);
        File blobFile = this.getBlobFile(hash);
        try {
            blobFile.setLastModified(System.currentTimeMillis());
            result = new FileInputStream(blobFile);
        }
        catch (FileNotFoundException swallow) {
            // empty catch block
        }
        return result;
    }

    public CacheStagingFile stage(byte[] identifier) throws IOException {
        Check.nonNull((Object)identifier, (String)"identifier");
        File file = this.getTempFile();
        return new CacheStagingFile(file, identifier, this);
    }

    public void cache(File file, byte[] identifier) throws IOException {
        Check.nonNull((Object)file, (String)"file");
        byte[] hash = this.hashIdentifier(identifier);
        File blobFile = this.getBlobFile(hash);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Caching " + new String(identifier) + " at " + blobFile));
        }
        IO.mkdirs((File)blobFile.getParentFile());
        if (!file.renameTo(blobFile)) {
            file.delete();
        }
    }

    byte[] hashIdentifier(byte[] identifier) {
        MessageDigest digest = IO.sha256Digester();
        return digest.digest(identifier);
    }

    File getBlobFile(byte[] hash) {
        String hashString = this.getString(hash);
        String dirName = hashString.substring(0, 2);
        String fileName = hashString;
        File dir = new File(this.blobsDir, dirName);
        return new File(dir, fileName);
    }

    File getTempFile() {
        String name = UUID.randomUUID().toString();
        return new File(this.tempDir, name);
    }

    String getString(byte[] hash) {
        String chars = "0123456789ABCDEF";
        char[] buffer = new char[hash.length * 2];
        int pos = 0;
        for (byte b : hash) {
            buffer[pos++] = chars.charAt(b >>> 4 & 0xF);
            buffer[pos++] = chars.charAt(b & 0xF);
        }
        return new String(buffer);
    }
}

