/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.util.IO;
import com.urbancode.ubuild.codestation.client.ArtifactDeliverPattern;
import com.urbancode.ubuild.codestation.client.BuildProcess;
import com.urbancode.ubuild.codestation.client.CodestationClient;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class BuildProcessLookup {
    private static final Logger log = Logger.getLogger(BuildProcessLookup.class);
    private final CodestationClient client;

    BuildProcessLookup(CodestationClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BuildProcess findBuildProcess(String projectId, String processId) throws Exception {
        if (StringUtils.isBlank((String)projectId)) {
            throw new Exception("Project id or name is required.");
        }
        if (StringUtils.isBlank((String)processId)) {
            throw new Exception("Process id or name is required.");
        }
        String findUrl = UriBuilder.fromPath((String)this.client.getUrl()).path("projects").path(projectId).path("buildProcesses").path(processId).build(new Object[0]).toString();
        BuildProcess process = null;
        HttpGet method = this.client.createHttpGet(findUrl);
        try {
            HttpResponse response = this.client.executeHttpMethod((HttpRequestBase)method);
            int code = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            switch (code) {
                case 200: {
                    String body = this.getEntityString(entity);
                    JSONObject json = new JSONObject(body);
                    String realBuildProcessId = json.getString("id");
                    String realProjectId = json.getString("projectId");
                    JSONArray jsonArtifactPatterns = json.getJSONArray("artifactPatterns");
                    ArtifactDeliverPattern[] artifactPatterns = new ArtifactDeliverPattern[jsonArtifactPatterns.length()];
                    for (int i = 0; i < jsonArtifactPatterns.length(); ++i) {
                        JSONObject jsonArtifactPattern = jsonArtifactPatterns.getJSONObject(i);
                        String artifactSet = jsonArtifactPattern.getString("set");
                        String baseDirectory = jsonArtifactPattern.getString("dir");
                        JSONArray jsonIncludes = jsonArtifactPattern.getJSONArray("includes");
                        String[] includes = this.jsonArrayToStringArray(jsonIncludes);
                        JSONArray jsonExcludes = jsonArtifactPattern.getJSONArray("excludes");
                        String[] excludes = this.jsonArrayToStringArray(jsonExcludes);
                        artifactPatterns[i] = new ArtifactDeliverPattern(artifactSet, baseDirectory, includes, excludes);
                    }
                    process = new BuildProcess(realProjectId, realBuildProcessId, artifactPatterns);
                    return process;
                }
                case 204: {
                    log.info((Object)("No build life found for project and build process " + projectId + " - " + processId));
                    return process;
                }
                case 404: {
                    throw new Exception("Project or build process could not be found for " + projectId + " - " + processId);
                }
                case 500: {
                    throw new Exception("Server error looking up build life: " + this.getEntityString(entity));
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private String[] jsonArrayToStringArray(JSONArray jsonArray) throws JSONException {
        String[] stringArray = new String[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            stringArray[i] = jsonArray.getString(i);
        }
        return stringArray;
    }

    private String getEntityString(HttpEntity entity) throws IOException {
        return EntityUtils.toString((HttpEntity)entity, (Charset)IO.utf8());
    }
}

