/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.util.IO;
import com.urbancode.ubuild.codestation.client.BuildLife;
import com.urbancode.ubuild.codestation.client.BuildLifeLookup;
import com.urbancode.ubuild.codestation.client.BuildProcess;
import com.urbancode.ubuild.codestation.client.CodestationClient;
import com.urbancode.ubuild.codestation.xml.Dependencies;
import com.urbancode.ubuild.codestation.xml.Project;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class DependenciesLookup {
    private static final Logger log = Logger.getLogger(BuildLifeLookup.class);
    private final CodestationClient client;

    DependenciesLookup(CodestationClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Dependencies findDependencies(BuildLife buildLife) throws Exception {
        String findUrl = UriBuilder.fromPath((String)this.client.getUrl()).path("build-lives").path(buildLife.getId()).path("dependencies-xml").build(new Object[0]).toString();
        Dependencies dependencies = null;
        HttpGet method = this.client.createHttpGet(findUrl);
        try {
            HttpResponse response = this.client.executeHttpMethod((HttpRequestBase)method);
            int code = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            switch (code) {
                case 200: {
                    JAXBContext context = JAXBContext.newInstance((String)Project.class.getPackage().getName(), (ClassLoader)Project.class.getClassLoader());
                    Unmarshaller unmarshaller = context.createUnmarshaller();
                    Project project = (Project)unmarshaller.unmarshal(this.getReader(entity));
                    dependencies = project.getDependencies();
                    return dependencies;
                }
                case 204: 
                case 404: {
                    log.info((Object)("No dependencies found for build life " + buildLife.getId()));
                    return dependencies;
                }
                case 500: {
                    throw new Exception("Server error looking up build life dependencies: " + this.getEntityString(entity));
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Dependencies findDependencies(BuildLife buildLife, File dependenciesXml) throws Exception {
        String findUrl = UriBuilder.fromPath((String)this.client.getUrl()).path("build-lives").path(buildLife.getId()).path("dependencies").build(new Object[0]).toString();
        Dependencies dependencies = null;
        HttpPost method = new HttpPost(findUrl);
        try {
            method.setEntity((HttpEntity)new FileEntity(dependenciesXml, ContentType.TEXT_XML));
            HttpResponse response = this.client.executeHttpMethod((HttpRequestBase)method);
            int code = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            switch (code) {
                case 200: {
                    JAXBContext context = JAXBContext.newInstance((String)Project.class.getPackage().getName(), (ClassLoader)Project.class.getClassLoader());
                    Unmarshaller unmarshaller = context.createUnmarshaller();
                    Project project = (Project)unmarshaller.unmarshal(this.getReader(entity));
                    dependencies = project.getDependencies();
                    return dependencies;
                }
                case 204: 
                case 404: {
                    log.info((Object)("No dependencies found for build life " + buildLife.getId()));
                    return dependencies;
                }
                case 500: {
                    throw new Exception("Server error looking up build life dependencies: " + this.getEntityString(entity));
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Dependencies findDependencies(BuildProcess process, File dependenciesXml) throws Exception {
        String findUrl = UriBuilder.fromPath((String)this.client.getUrl()).path("projects").path(process.getProjectId()).path("buildProcesses").path(process.getProcessId()).path("dependencies").build(new Object[0]).toString();
        Dependencies dependencies = null;
        HttpPut method = new HttpPut(findUrl);
        try {
            method.setEntity((HttpEntity)new FileEntity(dependenciesXml, ContentType.TEXT_XML));
            HttpResponse response = this.client.executeHttpMethod((HttpRequestBase)method);
            int code = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            switch (code) {
                case 200: {
                    JAXBContext context = JAXBContext.newInstance((String)Project.class.getPackage().getName(), (ClassLoader)Project.class.getClassLoader());
                    Unmarshaller unmarshaller = context.createUnmarshaller();
                    Project project = (Project)unmarshaller.unmarshal(this.getReader(entity));
                    dependencies = project.getDependencies();
                    return dependencies;
                }
                case 204: 
                case 404: {
                    log.info((Object)("No dependencies found for build process " + process.getProcessId()));
                    return dependencies;
                }
                case 500: {
                    throw new Exception("Server error looking up build process dependencies: " + this.getEntityString(entity));
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Dependencies findDependencies(BuildProcess process) throws Exception {
        String findUrl = UriBuilder.fromPath((String)this.client.getUrl()).path("projects").path(process.getProjectId()).path("buildProcesses").path(process.getProcessId()).path("dependenciesXml").build(new Object[0]).toString();
        Dependencies dependencies = null;
        HttpGet method = this.client.createHttpGet(findUrl);
        try {
            HttpResponse response = this.client.executeHttpMethod((HttpRequestBase)method);
            int code = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            switch (code) {
                case 200: {
                    JAXBContext context = JAXBContext.newInstance((String)Project.class.getPackage().getName(), (ClassLoader)Project.class.getClassLoader());
                    Unmarshaller unmarshaller = context.createUnmarshaller();
                    Project project = (Project)unmarshaller.unmarshal(this.getReader(entity));
                    dependencies = project.getDependencies();
                    return dependencies;
                }
                case 204: 
                case 404: {
                    log.info((Object)("No dependencies found for build process " + process.getProcessId()));
                    return dependencies;
                }
                case 500: {
                    throw new Exception("Server error looking up build process dependencies: " + this.getEntityString(entity));
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private String getEntityString(HttpEntity entity) throws IOException {
        return EntityUtils.toString((HttpEntity)entity, (Charset)IO.utf8());
    }

    private Reader getReader(HttpEntity entity) throws IOException {
        ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
        Charset charset = contentType.getCharset();
        InputStream iStream = entity.getContent();
        return IO.reader((InputStream)iStream, (Charset)charset);
    }
}

