/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.fileutils.DirectoryFileFilter;
import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.commons.fileutils.digest.DigestUtil;
import com.urbancode.commons.util.IO;
import com.urbancode.ubuild.codestation.client.ArtifactDeliverPattern;
import com.urbancode.ubuild.codestation.client.BuildProcess;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRepository {
    private final File repoDir;
    private final Logger log;

    private static String[] getFileArray(File baseDir, String[] includes, String[] excludes) {
        baseDir = baseDir.getAbsoluteFile();
        DirectoryFileFilter fileFilter = DirectoryFileFilter.getFilter((File)baseDir);
        System.out.println("copy file base:" + baseDir);
        for (String include : includes) {
            fileFilter.addInclude(include);
        }
        for (String exclude : excludes) {
            fileFilter.addExclude(exclude);
        }
        fileFilter.addExclude(DigestUtil.getDigestFileName());
        ArrayList<String> fileNameList = new ArrayList<String>();
        for (File file : LocalRepository.getDirectoryFiles(baseDir, fileFilter)) {
            String path = file.getAbsolutePath();
            path = path.substring(baseDir.getAbsolutePath().length());
            fileNameList.add(path);
        }
        String[] fileArray = new String[fileNameList.size()];
        fileNameList.toArray(fileArray);
        return fileArray;
    }

    private static Iterable<File> getDirectoryFiles(final File baseDir, final DirectoryFileFilter fileFilter) {
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return FileUtils.getDirectoryFiles((File)baseDir, (FileFilter)fileFilter);
            }
        };
    }

    private static void copySingleFile(File src, File dest) throws IOException {
        dest.getCanonicalFile().getParentFile().mkdirs();
        if (src.isDirectory()) {
            dest.mkdir();
        } else {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public LocalRepository(File repoDir, Logger log) {
        this.repoDir = repoDir;
        this.log = log;
    }

    public void clear() throws IOException {
        if (this.repoDir.isDirectory()) {
            File[] ls = this.repoDir.listFiles();
            for (int i = 0; i < ls.length; ++i) {
                IO.delete((File)ls[i]);
            }
        }
    }

    public void remove(String processId) throws IOException {
        File originatorDir = this.newProcessDir(processId);
        if (originatorDir.isDirectory()) {
            IO.delete((File)originatorDir);
        }
    }

    public void cleanArtifactSet(BuildProcess process, String artifactSetName) throws IOException {
        File setDir = this.getArtifactSetDir(process, artifactSetName);
        FileUtils.deleteFile((File)setDir);
    }

    public Date lastModified(BuildProcess process, ArtifactDeliverPattern artifactDeliver) throws IOException {
        File setDir = this.newSetDir(process, artifactDeliver.getArtifactSet());
        if (!setDir.exists()) {
            throw new IOException("Artifact set does not exist: " + setDir);
        }
        long lastModified = setDir.lastModified();
        if (lastModified == 0L) {
            throw new IOException("Error reading last-modified time for " + setDir);
        }
        return new Date(lastModified);
    }

    public boolean contains(BuildProcess process, ArtifactDeliverPattern artifactDeliver) {
        File setDir = this.newSetDir(process, artifactDeliver.getArtifactSet());
        return setDir.isDirectory();
    }

    public void addArtifactSet(File base, ArtifactDeliverPattern artifactDeliver, BuildProcess process) throws IOException {
        File scanBaseFile = base;
        String setName = artifactDeliver.getArtifactSet();
        File setDir = this.getArtifactSetDir(process, setName);
        setDir.mkdirs();
        String[] includes = artifactDeliver.getIncludes();
        String[] excludes = artifactDeliver.getExcludes();
        if (this.log != null) {
            StringBuilder includeMsg = new StringBuilder("Including [\n");
            if (includes != null && includes.length > 0) {
                for (String include : includes) {
                    includeMsg.append("\t");
                    includeMsg.append(include);
                    includeMsg.append("\n");
                }
            }
            includeMsg.append("];");
            StringBuilder excludeMsg = new StringBuilder("Excluding [\n");
            if (excludes != null && excludes.length > 0) {
                for (String exclude : excludes) {
                    excludeMsg.append("\t");
                    excludeMsg.append(exclude);
                    excludeMsg.append("\n");
                }
            }
            excludeMsg.append("];");
            this.log.debug((Object)("Base Dir " + scanBaseFile));
            this.log.debug((Object)includeMsg.toString());
            this.log.debug((Object)excludeMsg.toString());
        }
        String[] fileArray = LocalRepository.getFileArray(scanBaseFile, includes, excludes);
        if (this.log != null) {
            this.log.debug((Object)(fileArray.length + " files to copy"));
        }
        for (String element : fileArray) {
            File file = new File(scanBaseFile, element);
            File dest = new File(setDir, element);
            LocalRepository.copySingleFile(file, dest);
            if (this.log == null) continue;
            this.log.debug((Object)("Copied " + file + " to " + dest));
        }
        setDir.setLastModified(System.currentTimeMillis());
    }

    protected File getArtifactSetDir(BuildProcess process, String artifactSetName) {
        File setDir = this.newSetDir(process, artifactSetName);
        return setDir;
    }

    private File newProcessDir(String processId) {
        return new File(this.repoDir, processId);
    }

    private File newSetDir(BuildProcess process, String setName) {
        String id = process.getProcessId();
        File dir = this.newProcessDir(id);
        return new File(dir, setName);
    }
}

