/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def.parser;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.air.property.prop_def.parser.NamespaceContextMap;
import com.urbancode.air.property.prop_def.scripted.ScriptedPropInfo;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.logging.LogUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlParser {
    static final Logger log = Logger.getLogger(XmlParser.class);

    public static List<PropDefAllowedValue> parseXml(String rawData, HttpPropInfo info) throws Exception {
        return XmlParser.parseXml(rawData, info.getPropDef(), info.getBasePath(), info.getValuePath(), info.getLabelPath());
    }

    public static List<PropDefAllowedValue> parseXml(String rawData, ScriptedPropInfo info) throws Exception {
        return XmlParser.parseXml(rawData, info.getPropDef(), info.getBasePath(), info.getValuePath(), info.getLabelPath());
    }

    public static List<PropDefAllowedValue> parseXml(String rawData, PropDef propDef, String basePath, String valuePath, String labelPath) throws Exception {
        int i;
        ArrayList<PropDefAllowedValue> result = new ArrayList<PropDefAllowedValue>();
        InputSource inputSource = new InputSource(new StringReader(rawData));
        XPathFactory xPathFactory = XPathFactory.newInstance();
        inputSource = new InputSource(new StringReader(rawData));
        Map<String, String> namespaceContextMap = XmlParser.getNameSpaceContextMap(rawData, xPathFactory);
        XPath xpath = xPathFactory.newXPath();
        if (namespaceContextMap.size() > 0) {
            xpath.setNamespaceContext(new NamespaceContextMap(namespaceContextMap));
        }
        XPathExpression baseExpression = xpath.compile(basePath);
        XPathExpression nameExpression = null;
        XPathExpression labelExpression = null;
        if (!StringUtil.isEmpty((String)valuePath)) {
            nameExpression = xpath.compile(valuePath);
        }
        if (!StringUtil.isEmpty((String)labelPath)) {
            labelExpression = xpath.compile(labelPath);
        }
        LogUtil.logDebug((Logger)log, (Object)("Getting node list with XPath: " + basePath));
        NodeList nodeList = (NodeList)baseExpression.evaluate(inputSource, XPathConstants.NODESET);
        if (LogUtil.isTraceEnabled((Logger)log)) {
            try {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    LogUtil.logTrace((Logger)log, (Object)("Node " + i + ": " + XmlParser.serializeXmlNode(nodeList.item(i))));
                }
            }
            catch (Exception e) {
                LogUtil.logTrace((Logger)log, (Object)"An error occurred while attemping to log XML nodes.", (Throwable)e);
            }
        }
        LogUtil.logDebug((Logger)log, (Object)("Parsing XML node with name and label paths: " + valuePath + ", " + labelPath));
        for (i = 0; i < nodeList.getLength(); ++i) {
            LogUtil.logDebug((Logger)log, (Object)("Evaluating Node " + i));
            Node node = nodeList.item(i);
            String value = null;
            String label = null;
            if (nameExpression != null) {
                value = nameExpression.evaluate(node);
            } else {
                value = node.getNodeValue();
                if (value == null) {
                    value = node.getTextContent();
                }
            }
            label = labelExpression != null ? labelExpression.evaluate(node) : value;
            if (StringUtil.isEmpty((String)value)) {
                throw new TranslatableException("Unable to find property names using XPath statement %s", new Object[]{valuePath});
            }
            LogUtil.logTrace((Logger)log, (Object)("Value, Label: " + value + ", " + label));
            PropDefAllowedValue allowedValue = new PropDefAllowedValue(propDef, value, label);
            result.add(allowedValue);
        }
        return result;
    }

    private static Map<String, String> getNameSpaceContextMap(String rawData, XPathFactory xPathFactory) throws XPathExpressionException {
        InputSource inputSource = new InputSource(new StringReader(rawData));
        HashMap<String, String> nameSpaces = new HashMap<String, String>();
        XPath xpath = xPathFactory.newXPath();
        XPathExpression nameSpaceExpression = xpath.compile("//namespace::*");
        NodeList nameSpaceList = (NodeList)nameSpaceExpression.evaluate(inputSource, XPathConstants.NODESET);
        for (int i = 0; i < nameSpaceList.getLength(); ++i) {
            Node node = nameSpaceList.item(i);
            nameSpaces.put(node.getLocalName(), node.getNodeValue());
        }
        return nameSpaces;
    }

    private static String serializeXmlNode(Node node) throws Exception {
        StringWriter sw = new StringWriter();
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.transform(new DOMSource(node), new StreamResult(sw));
        String result = sw.toString();
        return result;
    }
}

