/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet_def;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.PropertyConfiguration;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefDeletedEvent;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet.PropSheetFactory;
import com.urbancode.air.property.prop_sheet.PropSheetFactoryRegistry;
import com.urbancode.air.property.prop_sheet.PropSheetHandle;
import com.urbancode.air.property.prop_sheet.PropSheetLookup;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactoryRegistry;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroup;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroupFactoryRegistry;
import com.urbancode.air.services.event.Event;
import com.urbancode.air.services.event.EventSender;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.PersistenceData;
import com.urbancode.air.vc.Persistent;
import com.urbancode.persistence.IDGenerator;
import com.urbancode.persistence.hibernate.AbstractEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.ObjectUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="propSheetsCache")
@Entity
@Table(name="ps_prop_sheet_def")
public class PropSheetDef
extends AbstractEntity<UUID>
implements Persistent {
    private static final long serialVersionUID = 415302221908L;
    @Transient
    private PersistenceData persistenceData = new PersistenceData((Persistent)this, true);
    @Id
    @Column(name="id")
    @Type(type="uuid-char")
    UUID id = IDGenerator.createID();
    @Column(name="name")
    String name;
    @Column(name="description")
    String description;
    @OneToMany(orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    @IndexColumn(name="index_order", nullable=false, base=0)
    @JoinColumn(name="prop_sheet_def_id", nullable=false)
    List<PropDef> propDefs = new ArrayList<PropDef>();
    @Transient
    Handle propSheetGroupHandle;
    @ManyToOne
    @JoinColumn(name="prop_sheet_group_id")
    private PropSheetGroup propSheetGroup;
    @Column(name="template_handle")
    String templateHandleString;
    @ManyToOne
    @JoinColumn(name="template_prop_sheet_def_id")
    private PropSheetDef templatePropSheetDef;
    @Transient
    UUID templatePropSheetDefId;
    @OneToMany(mappedBy="propSheetDef", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    private Set<PropSheet> propSheets = new HashSet<PropSheet>();
    @Transient
    Set<UUID> propSheetIds = new HashSet<UUID>();
    @OneToMany(mappedBy="propSheetDef", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    Set<PropSheetHandle> propSheetHandles = new HashSet<PropSheetHandle>();

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.persistenceData.setDirty(true);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.persistenceData.setDirty(true);
    }

    public List<PropDef> getPropDefList() {
        ArrayList<PropDef> result = new ArrayList<PropDef>();
        HashSet<String> names = new HashSet<String>();
        for (PropDef propDef : this.propDefs) {
            result.add(propDef);
            names.add(propDef.getName());
        }
        PropSheetDef template = this.getTemplate();
        if (template != null) {
            for (PropDef propDef : template.getPropDefList()) {
                if (names.contains(propDef.getName())) continue;
                result.add(propDef);
            }
        }
        return result;
    }

    public List<PropDef> getDirectPropDefList() {
        ArrayList<PropDef> result = new ArrayList<PropDef>(this.propDefs);
        return result;
    }

    public void addPropDef(PropDef propDef) {
        for (PropDef propDefCheck : this.propDefs) {
            if (!ObjectUtils.equals((Object)propDefCheck.getName(), (Object)propDef.getName())) continue;
            throw new TranslatableException("A PropDef named %s already exists in this PropSheetDef.", new Object[]{propDef.getName()});
        }
        this.propDefs.add(propDef);
        this.persistenceData.setDirty(true);
    }

    public void removePropDef(PropDef propDef) {
        if (!this.propDefs.contains(propDef)) {
            throw new TranslatableException("This PropSheetDef named %s does not contain the given PropDef named %s.", new Object[]{this.getName(), propDef.getName()});
        }
        this.propDefs.remove(propDef);
        this.sendDeletedPropEvent(propDef);
        this.persistenceData.setDirty(true);
    }

    private void sendDeletedPropEvent(PropDef propDef) {
        PropertyConfiguration config = PropertyConfiguration.getInstance();
        EventSender eventSender = config.getEventSender();
        if (eventSender != null) {
            PropDefDeletedEvent deletedPropEvent = new PropDefDeletedEvent(propDef);
            eventSender.sendEvent((Event)deletedPropEvent);
        }
    }

    public void movePropDef(PropDef propDef, int index) throws IllegalArgumentException {
        int maxIndex = this.propDefs.size() - 1;
        if (this.propDefs.contains(propDef)) {
            if (index < 0 || index > maxIndex) {
                throw new IllegalArgumentException("Index '" + index + "' is invalid. The index should be a value " + "between 0 and " + maxIndex + ".");
            }
        } else {
            throw new TranslatableException("This PropSheetDef named %s does not contain the given PropDef named %s.", new Object[]{this.getName(), propDef.getName()});
        }
        this.propDefs.remove(propDef);
        this.propDefs.add(index, propDef);
        this.persistenceData.setDirty(true);
    }

    public PropDef createPropDef(PropDef.PropDefType type, String name) {
        if (this.getDirectPropDef(name) != null) {
            throw new TranslatableException("Property definition with name '%s' already exists in group %s.", new Object[]{name, this});
        }
        PropDef result = new PropDef(this, name);
        result.setType(type);
        this.addPropDef(result);
        return result;
    }

    public PropDef getDirectPropDef(String name) {
        return this.getPropDefFromList(name, this.getDirectPropDefList());
    }

    public PropDef getPropDef(String name) {
        return this.getPropDefFromList(name, this.getPropDefList());
    }

    private PropDef getPropDefFromList(String name, List<PropDef> list) {
        PropDef result = null;
        for (PropDef propDef : list) {
            if (!propDef.getName().equals(name)) continue;
            result = propDef;
            break;
        }
        return result;
    }

    public Set<PropSheet> getPropSheetList() {
        PropSheet propSheet;
        HashSet<PropSheet> result = null;
        PropSheetFactory factory = PropSheetFactoryRegistry.getFactory();
        result = new HashSet<PropSheet>();
        result.addAll(this.propSheets);
        for (UUID propSheetId : this.propSheetIds) {
            propSheet = factory.getPropSheetForId(propSheetId);
            if (propSheet == null) continue;
            result.add(propSheet);
        }
        for (PropSheetHandle propSheetHandle : this.propSheetHandles) {
            propSheet = factory.getPropSheetForHandle(propSheetHandle.getHandle());
            if (propSheet == null) continue;
            result.add(propSheet);
        }
        return result;
    }

    public void addPropSheet(PropSheet propSheet) {
        if (propSheet.isVersioned()) {
            Handle handle = new Handle(propSheet.getPersistenceData().getPath(), Integer.valueOf(-1));
            this.propSheetHandles.add(new PropSheetHandle(this, handle));
        } else if (this.isVersioned()) {
            this.propSheetIds.add(propSheet.getId());
        } else {
            this.propSheets.add(propSheet);
        }
        if (!ObjectUtils.equals((Object)((Object)this), (Object)((Object)propSheet.getPropSheetDef()))) {
            propSheet.setPropSheetDef(this);
        }
        this.persistenceData.setDirty(true);
    }

    public void removePropSheet(PropSheet propSheet) {
        if (propSheet.isVersioned()) {
            Handle handle = new Handle(propSheet.getPersistenceData().getPath(), Integer.valueOf(-1));
            HashSet<PropSheetHandle> handlesToRemove = new HashSet<PropSheetHandle>();
            for (PropSheetHandle propSheetHandle : this.propSheetHandles) {
                if (!propSheetHandle.getHandle().equals((Object)handle)) continue;
                handlesToRemove.add(propSheetHandle);
            }
            this.propSheetHandles.removeAll(handlesToRemove);
        } else if (this.isVersioned()) {
            this.propSheetIds.remove(propSheet.getId());
        } else {
            this.propSheets.remove((Object)propSheet);
        }
        propSheet.setPropSheetDef(null);
        this.persistenceData.setDirty(true);
    }

    public PropSheetGroup getPropSheetGroup() {
        PropSheetGroup result = null;
        if (this.propSheetGroup != null) {
            result = this.propSheetGroup;
        } else if (this.propSheetGroupHandle != null) {
            result = PropSheetGroupFactoryRegistry.getFactory().getPropSheetGroupForHandle(this.propSheetGroupHandle);
        }
        return result;
    }

    public void setPropSheetGroup(PropSheetGroup propSheetGroup) {
        this.propSheetGroupHandle = null;
        this.propSheetGroup = null;
        if (propSheetGroup != null) {
            if (propSheetGroup.isVersioned()) {
                Handle propSheetGroupHandle;
                this.propSheetGroupHandle = propSheetGroupHandle = new Handle(propSheetGroup.getPersistenceData().getPath(), Integer.valueOf(-1));
            } else {
                this.propSheetGroup = propSheetGroup;
            }
        }
        this.persistenceData.setDirty(true);
    }

    public PropSheetDef getTemplate() {
        PropSheetDef result = null;
        if (this.templatePropSheetDef != null) {
            result = this.templatePropSheetDef;
        } else if (this.templatePropSheetDefId != null) {
            result = PropSheetDefFactoryRegistry.getFactory().getPropSheetDefForId(this.templatePropSheetDefId);
        } else if (this.templateHandleString != null) {
            Handle handle = new Handle(this.templateHandleString);
            result = PropSheetDefFactoryRegistry.getFactory().getPropSheetDefForHandle(handle);
        }
        return result;
    }

    public void setTemplate(PropSheetDef templatePropSheetDef) {
        this.setTemplate(templatePropSheetDef, false);
    }

    public void setTemplate(PropSheetDef templatePropSheetDef, boolean useSpecificVersion) {
        PropSheetLookup lookup;
        if (this.getTemplate() != null && (lookup = PropertyConfiguration.getInstance().getPropSheetLookup()) != null) {
            Set<PropSheet> propSheets = lookup.getPropSheetsForPropSheetDef(this);
            for (PropSheet ps : propSheets) {
                ps.updateFromPropSheetDef(templatePropSheetDef);
            }
        }
        this.templateHandleString = null;
        this.templatePropSheetDefId = null;
        this.templatePropSheetDef = null;
        if (templatePropSheetDef != null) {
            if (templatePropSheetDef.isVersioned()) {
                int version = -1;
                if (useSpecificVersion) {
                    version = templatePropSheetDef.getPersistenceData().getRelativeVersion();
                }
                Handle templatePropSheetDefHandle = new Handle(templatePropSheetDef.getPersistenceData().getPath(), Integer.valueOf(version));
                this.templateHandleString = templatePropSheetDefHandle.toString();
            } else if (this.isVersioned()) {
                this.templatePropSheetDefId = templatePropSheetDef.getId();
            } else {
                this.templatePropSheetDef = templatePropSheetDef;
            }
        }
        this.persistenceData.setDirty(true);
    }

    public boolean isVersioned() {
        return this.persistenceData.getPath() != null;
    }

    public PersistenceData getPersistenceData() {
        return this.persistenceData;
    }
}

