/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet;

import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_value.PropValue;
import com.urbancode.air.property.web.rest.PropSheetResource;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.webext.util.JSONOutputType;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.codehaus.jettison.json.JSONObject;
import org.hibernate.HibernateException;
import org.hibernate.type.ClobType;
import org.hibernate.usertype.UserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropSheetType
implements UserType {
    public Object deepCopy(Object value) throws HibernateException {
        PropSheet result = null;
        if (value != null) {
            PropSheet propSheet = (PropSheet)((Object)value);
            result = new PropSheet();
            result.setName(propSheet.getName());
            for (PropValue propValue : propSheet.getPropValueList()) {
                result.addPropValue(this.copyPropValue(propValue));
            }
        }
        return result;
    }

    private PropValue copyPropValue(PropValue original) {
        PropValue result = new PropValue(original.getName(), original.getValue(), original.isSecure());
        result.setDescription(original.getDescription());
        return result;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        boolean result = false;
        if (x != null && y != null) {
            PropSheet xPropSheet = (PropSheet)((Object)x);
            PropSheet yPropSheet = (PropSheet)((Object)y);
            return ((Object)xPropSheet.getPropMap()).equals(yPropSheet.getPropMap());
        }
        if (x == null && y == null) {
            result = true;
        }
        return result;
    }

    public int hashCode(Object x) throws HibernateException {
        int result = 0;
        if (x != null) {
            result = ((Object)((PropSheet)((Object)x)).getPropMap()).hashCode();
        }
        return result;
    }

    public boolean isMutable() {
        return true;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Clob clobValue = rs.getClob(names[0]);
        PropSheet result = null;
        if (clobValue != null) {
            try {
                String jsonString = IO.readText((Reader)clobValue.getCharacterStream());
                JSONObject propSheetJson = new JSONObject(jsonString);
                result = new PropSheet();
                PropSheetResource.getInstance().importPropSheet(result, propSheetJson, false);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to deserialize PropSheet from JSON", e);
            }
        }
        return result;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setClob(index, (Clob)null);
        } else {
            try {
                JSONObject propSheetJson = PropSheetResource.getInstance().toJSON((Object)((PropSheet)((Object)value)), new JSONOutputType[]{JSONOutputType.EXPORT});
                String propSheetJsonString = propSheetJson.toString();
                st.setCharacterStream(index, (Reader)IO.reader((String)propSheetJsonString), propSheetJsonString.length());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to serialize PropSheet to JSON", e);
            }
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }

    public Class<?> returnedClass() {
        return PropSheet.class;
    }

    public int[] sqlTypes() {
        return new int[]{ClobType.INSTANCE.sqlType()};
    }
}

