/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.PropertyConfiguration;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_def.PropDefDefaultValueEvent;
import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.air.property.prop_def.scripted.ScriptedPropInfo;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactoryRegistry;
import com.urbancode.air.services.event.Event;
import com.urbancode.air.services.event.EventSender;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.crypto.CryptStringUtil;
import com.urbancode.persistence.IDGenerator;
import com.urbancode.persistence.hibernate.AbstractEntity;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="propSheetsCache")
@Entity
@Table(name="ps_prop_def", uniqueConstraints={@UniqueConstraint(columnNames={"prop_sheet_def_id", "name"})})
public class PropDef
extends AbstractEntity<UUID>
implements Comparable<PropDef> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(PropDef.class);
    public static final String SECURE_MASK_VALUE = "****";
    @Id
    @Column(name="id")
    @Type(type="uuid-char")
    protected UUID id = IDGenerator.createID();
    @NotNull
    @ManyToOne(optional=false)
    @JoinColumn(name="prop_sheet_def_id", insertable=false, updatable=false, nullable=false)
    protected PropSheetDef propSheetDef;
    @NotNull
    @Column(name="name")
    @Length(min=1, max=256)
    protected String name = null;
    @Column(name="description")
    @Length(max=4000)
    protected String description = null;
    @Column(name="placeholder")
    @Length(max=4000)
    protected String placeholder = null;
    @Column(name="property_type")
    protected String typeName = PropDefType.TEXT.toString();
    protected transient PropDefType type;
    @Column(name="label")
    @Length(max=256)
    protected String label = null;
    @Column(name="default_value")
    @Length(max=4000)
    protected String defaultValue = null;
    @Column(name="default_label")
    @Length(max=4000)
    protected String defaultLabel = null;
    @Column(name="pattern")
    @Length(max=256)
    protected String pattern = null;
    @Lob
    @Column(name="long_default_value")
    String longDefaultValue;
    @Lob
    @Column(name="long_default_label")
    String longDefaultLabel;
    @NotNull
    @Column(name="required")
    @Type(type="yes_no")
    protected Boolean required = false;
    @NotNull
    @Column(name="hidden")
    @Type(type="yes_no")
    protected Boolean hidden = false;
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    @IndexColumn(name="index_order", nullable=false, base=0)
    @JoinColumn(name="prop_def_id", nullable=false)
    protected List<PropDefAllowedValue> allowedValues = new ArrayList<PropDefAllowedValue>();
    @Column(name="allowed_prop_sheet_def_id")
    @Type(type="uuid-char")
    protected UUID allowedPropSheetDefReference;
    @OneToOne(mappedBy="propDef", fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL})
    protected HttpPropInfo httpPropInfo;
    @OneToOne(mappedBy="propDef", fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL})
    protected ScriptedPropInfo scriptedPropInfo;
    transient boolean typeHasBeenSet = true;

    protected PropDef() {
    }

    public PropDef(PropSheetDef propSheetDef, String name) {
        if (propSheetDef == null) {
            throw new IllegalArgumentException("Property definition requires a property sheet definition");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Property definition requires a name");
        }
        this.propSheetDef = propSheetDef;
        if (propSheetDef.getTemplate() != null && propSheetDef.getTemplate().getPropDef(name) != null) {
            this.defaultValue = propSheetDef.getTemplate().getPropDef(name).getDefaultValue();
        }
        this.name = name;
        this.typeHasBeenSet = false;
    }

    public PropDef(PropSheetDef propSheetDef, PropDef copy) {
        if (propSheetDef == null) {
            throw new IllegalArgumentException("Property definition requires a property sheet definition");
        }
        if (copy == null) {
            throw new IllegalArgumentException("Copying a property definition requires a property definition");
        }
        this.propSheetDef = propSheetDef;
        this.defaultValue = copy.defaultValue;
        this.defaultLabel = copy.defaultLabel;
        this.description = copy.description;
        this.hidden = copy.hidden;
        this.label = copy.label;
        this.pattern = copy.pattern;
        this.name = copy.name;
        this.required = copy.required;
        this.typeName = copy.typeName;
        this.type = copy.type;
        if (copy.allowedValues != null) {
            this.allowedValues = new ArrayList<PropDefAllowedValue>();
            for (PropDefAllowedValue allowedValue : copy.allowedValues) {
                this.addAllowedValue(allowedValue.getValue(), allowedValue.getLabel());
            }
        }
        this.httpPropInfo = copy.getHttpPropInfo() != null ? new HttpPropInfo(this, copy.getHttpPropInfo()) : null;
        this.scriptedPropInfo = copy.getScriptedPropInfo() != null ? new ScriptedPropInfo(this, copy.getScriptedPropInfo()) : null;
    }

    public UUID getId() {
        return this.id;
    }

    public PropSheetDef getPropSheetDef() {
        return this.propSheetDef;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != null) {
            throw new UnsupportedOperationException("Cannot change the name of a persisted property definition.");
        }
        this.name = name;
        this.propSheetDef.getPersistenceData().setDirty(true);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.propSheetDef.getPersistenceData().setDirty(true);
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        this.propSheetDef.getPersistenceData().setDirty(true);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.propSheetDef.getPersistenceData().setDirty(true);
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isValidValue(String value) {
        return this.isValidValue(value, this.pattern);
    }

    private boolean isValidValue(String value, String pattern) {
        boolean result = true;
        if (!StringUtil.isEmpty((String)pattern) && !StringUtil.isEmpty((String)value)) {
            if (this.type.isMultiValued()) {
                String[] vals;
                for (String val : vals = value.split(",")) {
                    if (val.matches(pattern)) continue;
                    result = false;
                    break;
                }
            } else {
                result = value.matches(pattern);
            }
        }
        return result;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.propSheetDef.getPersistenceData().setDirty(true);
    }

    public String getDefaultValue() {
        String result;
        String string = result = StringUtil.isEmpty((String)this.longDefaultValue) ? this.defaultValue : this.longDefaultValue;
        if (result == null) {
            result = "";
        } else {
            try {
                if (CryptStringUtil.isEncrypted((String)result)) {
                    result = CryptStringUtil.decrypt((String)result);
                }
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Error decrypting value", e);
            }
        }
        return result;
    }

    public String getRawDefaultValue() {
        String result = this.defaultValue;
        if (StringUtils.isEmpty((String)result)) {
            result = this.longDefaultValue;
        }
        return result;
    }

    public String getSafeDefaultValue() {
        String result = this.getDefaultValue();
        if (this.isSecure() && !StringUtils.isEmpty((String)result)) {
            result = SECURE_MASK_VALUE;
        }
        return result;
    }

    public void setDefaultValue(String value) {
        this.setTypeNameAndDefaultValue(this.typeName, value);
    }

    private void setValueProperty(String newValue) {
        if (newValue.length() > 4000) {
            this.longDefaultValue = newValue;
            this.defaultValue = null;
        } else {
            this.longDefaultValue = null;
            this.defaultValue = newValue;
        }
    }

    public String getDefaultLabel() {
        String result = StringUtil.isEmpty((String)this.longDefaultLabel) ? this.defaultLabel : this.longDefaultLabel;
        return result;
    }

    public void setDefaultLabel(String defaultLabel) {
        if (defaultLabel == null) {
            this.defaultLabel = null;
            this.longDefaultLabel = null;
        } else if (defaultLabel.length() > 4000) {
            this.longDefaultLabel = defaultLabel;
            this.defaultLabel = null;
        } else {
            this.defaultLabel = defaultLabel;
            this.longDefaultLabel = null;
        }
    }

    private void sendDefaultValueEvent(String oldValue, String newValue) {
        PropertyConfiguration config = PropertyConfiguration.getInstance();
        EventSender eventSender = config.getEventSender();
        if (eventSender != null) {
            PropDefDefaultValueEvent defaultValueEvent = new PropDefDefaultValueEvent(this, oldValue, newValue);
            eventSender.sendEvent((Event)defaultValueEvent);
        }
    }

    public List<PropDefAllowedValue> getAllowedValues() {
        ArrayList<PropDefAllowedValue> result = new ArrayList<PropDefAllowedValue>();
        for (PropDefAllowedValue value : this.allowedValues) {
            result.add(value);
        }
        return result;
    }

    public List<String> getAllowedValueStrings() {
        ArrayList<String> result = new ArrayList<String>();
        for (PropDefAllowedValue value : this.allowedValues) {
            result.add(value.getValue());
        }
        return result;
    }

    public List<String> getAllowedValueLabels() {
        ArrayList<String> result = new ArrayList<String>();
        for (PropDefAllowedValue value : this.getAllowedValues()) {
            if (!StringUtils.isNotBlank((String)value.getLabel())) continue;
            result.add(value.getLabel());
        }
        return result;
    }

    public void addAllowedValue(String value, String label) {
        if (this.getType().isHttpBased()) {
            throw new TranslatableException("Cannot set allowed values on HTTP properties.", new Object[0]);
        }
        if (this.getType().isScriptedBased()) {
            throw new TranslatableException("Cannot set allowed values on Scripted properties.", new Object[0]);
        }
        this.allowedValues.add(new PropDefAllowedValue(this, value, label));
    }

    public boolean removeAllowedValue(PropDefAllowedValue allowedValue) {
        this.propSheetDef.getPersistenceData().setDirty(true);
        return this.allowedValues.remove((Object)allowedValue);
    }

    public void removeAllAllowedValues() {
        this.allowedValues.clear();
        this.propSheetDef.getPersistenceData().setDirty(true);
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
        this.propSheetDef.getPersistenceData().setDirty(true);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.propSheetDef.getPersistenceData().setDirty(true);
    }

    public PropDefType getType() {
        if (this.type == null) {
            this.type = PropDefType.internalValueOf(this.typeName);
        }
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    private void setTypeNameAndDefaultValue(String typeName, String defaultValue) {
        boolean hasChange = false;
        boolean setDefault = false;
        String currentDefault = this.getDefaultValue();
        if (StringUtils.isBlank((String)typeName)) {
            throw new IllegalArgumentException("Type is required.");
        }
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (!this.typeName.equals(typeName)) {
            if (this.typeHasBeenSet) {
                throw new UnsupportedOperationException("Cannot change the type of a prop def once it has been set. Instead delete the property and recreate it. Changed type of property " + this.getName() + " from " + this.typeName + " to " + typeName);
            }
            this.typeName = typeName;
            this.type = PropDefType.internalValueOf(typeName);
            setDefault = true;
            hasChange = true;
            this.typeHasBeenSet = true;
        }
        if (!StringUtils.equals((String)defaultValue, (String)currentDefault) || setDefault) {
            if (!this.isValidValue(defaultValue)) {
                throw new TranslatableException("Value for property definition named '%s' is not valid. Check that it matches any pattern defined by the property definition!", new Object[]{this.name});
            }
            if (this.isSecure()) {
                if (!SECURE_MASK_VALUE.equals(defaultValue)) {
                    try {
                        String newValue = CryptStringUtil.encrypt((String)defaultValue);
                        this.setValueProperty(newValue);
                        this.sendDefaultValueEvent(currentDefault, defaultValue);
                        hasChange = true;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error encrypting value", e);
                    }
                }
            } else {
                this.setValueProperty(defaultValue);
                this.sendDefaultValueEvent(currentDefault, defaultValue);
                hasChange = true;
            }
        }
        if (!hasChange && !this.typeHasBeenSet) {
            this.typeHasBeenSet = true;
            this.sendDefaultValueEvent(currentDefault, defaultValue);
        }
        if (hasChange) {
            this.propSheetDef.getPersistenceData().setDirty(true);
        }
    }

    public void setType(PropDefType type) {
        this.setTypeNameAndDefaultValue(type.toString(), this.getDefaultValue());
        this.typeHasBeenSet = true;
    }

    public void setTypeName(String typeName) {
        this.setTypeNameAndDefaultValue(typeName, this.getDefaultValue());
        this.typeHasBeenSet = true;
    }

    public boolean isSecure() {
        return PropDefType.SECURE.equals((Object)this.getType());
    }

    public void setPropSheetDef(PropSheetDef propSheetDef) {
        if (this.propSheetDef != null) {
            throw new UnsupportedOperationException("Cannot set PropSheetDef when it has already been set.");
        }
        this.propSheetDef = propSheetDef;
        propSheetDef.getPersistenceData().setDirty(true);
    }

    public PropSheetDef getAllowedPropSheetDef() {
        PropSheetDef allowedPropSheetDef = null;
        if (PropDefType.PROP_SHEET_REF == this.getType()) {
            allowedPropSheetDef = PropSheetDefFactoryRegistry.getFactory().getPropSheetDefForId(this.allowedPropSheetDefReference);
        }
        return allowedPropSheetDef;
    }

    public void setAllowedPropSheetDef(PropSheetDef allowedPropSheetDef) {
        if (PropDefType.PROP_SHEET_REF == this.getType()) {
            this.allowedPropSheetDefReference = allowedPropSheetDef.getId();
        }
        this.propSheetDef.getPersistenceData().setDirty(true);
    }

    public HttpPropInfo getHttpPropInfo() {
        if (this.getType().isHttpBased() && this.httpPropInfo == null) {
            this.httpPropInfo = new HttpPropInfo(this);
        }
        return this.httpPropInfo;
    }

    public ScriptedPropInfo getScriptedPropInfo() {
        if (this.getType().isScriptedBased() && this.scriptedPropInfo == null) {
            this.scriptedPropInfo = new ScriptedPropInfo(this);
        }
        return this.scriptedPropInfo;
    }

    @Override
    public int compareTo(PropDef other) {
        return this.name.toLowerCase().compareTo(other.getName().toLowerCase());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropDefNameComparator
    implements Comparator<PropDef> {
        @Override
        public int compare(PropDef property1, PropDef property2) {
            String name1 = property1.getName();
            String name2 = property2.getName();
            int result = 0;
            result = name1 == null ? -1 : (name2 == null ? 1 : name1.compareToIgnoreCase(name2));
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropDefType {
        TEXT,
        TEXTAREA,
        VALIDATION_TEXT,
        PASSWORD,
        CHECKBOX,
        SELECT,
        MULTI_SELECT,
        SECURE,
        PROP_SHEET_REF,
        CUSTOM,
        HTTP_SELECT,
        HTTP_MULTI_SELECT,
        HTTP_CHECKED_MULTI_SELECT,
        SCRIPTED_SELECT,
        SCRIPTED_MULTI_SELECT,
        SCRIPTED_CHECKED_MULTI_SELECT,
        CHECKED_MULTI_SELECT,
        BUTTON,
        PARAGRAPH,
        DATETIME;


        static PropDefType internalValueOf(String typeName) {
            try {
                return PropDefType.valueOf(typeName);
            }
            catch (IllegalArgumentException e) {
                return CUSTOM;
            }
        }

        public boolean isMultiValued() {
            return MULTI_SELECT.equals((Object)this) || HTTP_MULTI_SELECT.equals((Object)this) || SCRIPTED_MULTI_SELECT.equals((Object)this) || HTTP_CHECKED_MULTI_SELECT.equals((Object)this) || SCRIPTED_CHECKED_MULTI_SELECT.equals((Object)this);
        }

        public boolean hasAllowedValues() {
            return MULTI_SELECT.equals((Object)this) || SELECT.equals((Object)this);
        }

        public boolean isHttpBased() {
            return HTTP_MULTI_SELECT.equals((Object)this) || HTTP_SELECT.equals((Object)this) || HTTP_CHECKED_MULTI_SELECT.equals((Object)this);
        }

        public boolean isScriptedBased() {
            return SCRIPTED_CHECKED_MULTI_SELECT.equals((Object)this) || SCRIPTED_SELECT.equals((Object)this) || SCRIPTED_MULTI_SELECT.equals((Object)this) || BUTTON.equals((Object)this);
        }
    }
}

