/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_value;

import com.urbancode.air.property.prop_value.PropValue;
import com.urbancode.air.vc.xml.XMLVCHelper;
import com.urbancode.commons.xml.DOMUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropValueVCHelper
extends XMLVCHelper<PropValue> {
    public static final String PROP_VALUE_ELEMENT = "propValue";
    public static final String PROP_VALUES_ELEMENT = "propValues";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String VALUE_ELEMENT = "value";
    public static final String LONG_VALUE_ELEMENT = "longValue";
    public static final String LABEL_ELEMENT = "label";
    public static final String LONG_LABEL_ELEMENT = "longLabel";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String SECURE_ATTRIBUTE = "secure";

    public PropValue toObject(Element element) {
        Element longLabelElement;
        Element labelElement;
        Element longValueElement;
        PropValue result = new PropValue();
        result.id = this.getUUIDAttribute(element, ID_ATTRIBUTE);
        result.name = element.getAttribute(NAME_ATTRIBUTE);
        result.description = element.getAttribute(DESCRIPTION_ATTRIBUTE);
        result.secure = this.getBooleanAttribute(element, SECURE_ATTRIBUTE);
        Element valueElement = DOMUtils.getFirstChild((Element)element, (String)VALUE_ELEMENT);
        if (valueElement != null) {
            result.value = DOMUtils.getChildText((Element)valueElement);
        }
        if ((longValueElement = DOMUtils.getFirstChild((Element)element, (String)LONG_VALUE_ELEMENT)) != null) {
            result.longValue = DOMUtils.getChildText((Element)longValueElement);
        }
        if ((labelElement = DOMUtils.getFirstChild((Element)element, (String)LABEL_ELEMENT)) != null) {
            result.label = DOMUtils.getChildText((Element)labelElement);
        }
        if ((longLabelElement = DOMUtils.getFirstChild((Element)element, (String)LONG_LABEL_ELEMENT)) != null) {
            result.longLabel = DOMUtils.getChildText((Element)longLabelElement);
        }
        return result;
    }

    public Element toXML(PropValue object, Document doc) {
        Element element = doc.createElement(this.getObjectElementName());
        element.setAttribute(ID_ATTRIBUTE, object.getId().toString());
        element.setAttribute(NAME_ATTRIBUTE, object.name);
        element.setAttribute(SECURE_ATTRIBUTE, Boolean.toString(object.secure));
        element.setAttribute(DESCRIPTION_ATTRIBUTE, object.description);
        if (!StringUtils.isEmpty((String)object.value)) {
            element.appendChild(this.createTextElement(doc, VALUE_ELEMENT, object.value));
        }
        if (!StringUtils.isEmpty((String)object.longValue)) {
            element.appendChild(this.createTextElement(doc, LONG_VALUE_ELEMENT, object.longValue));
        }
        if (!StringUtils.isEmpty((String)object.label)) {
            element.appendChild(this.createTextElement(doc, LABEL_ELEMENT, object.label));
        }
        if (!StringUtils.isEmpty((String)object.longLabel)) {
            element.appendChild(this.createTextElement(doc, LONG_LABEL_ELEMENT, object.longLabel));
        }
        return element;
    }

    public String getObjectElementName() {
        return PROP_VALUE_ELEMENT;
    }

    public String getObjectCollectionElementName() {
        return PROP_VALUES_ELEMENT;
    }

    public Class<PropValue> getPersistentClass() {
        return PropValue.class;
    }
}

