/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.web.rest;

import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefTree;
import com.urbancode.air.property.web.rest.PropDefResource;
import com.urbancode.commons.webext.util.JSONOutputType;
import com.urbancode.commons.webext.util.JSONUtilities;
import java.util.List;
import javax.ws.rs.Path;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

@Path(value="propSheetDefTree")
public class PropSheetDefTreeResource {
    private static PropSheetDefTreeResource instance = new PropSheetDefTreeResource();

    public static PropSheetDefTreeResource getInstance() {
        return instance;
    }

    public JSONArray getFlatPropDefArray(PropSheetDefTree propSheetDefTree) throws Exception {
        JSONArray result = new JSONArray();
        PropSheetDef propSheetDef = propSheetDefTree.getPropSheetDef();
        List<PropSheetDefTree> children = propSheetDefTree.getChildPropSheetDefTreeList();
        if (propSheetDef != null) {
            List<PropDef> propDefList = propSheetDef.getPropDefList();
            for (PropDef propDef : propDefList) {
                if (propSheetDefTree.isIgnoring(propDef.getName()) || propDef.isHidden()) continue;
                JSONObject propertyJsonObject = PropDefResource.getInstance().toJSON(propDef, new JSONOutputType[0]);
                result.put((Object)propertyJsonObject);
            }
        }
        for (PropSheetDefTree child : children) {
            JSONArray childJsonArray = this.getFlatPropDefArray(child);
            String childName = child.getName();
            for (int i = 0; i < childJsonArray.length(); ++i) {
                JSONObject childProperty = childJsonArray.getJSONObject(i);
                String propertyName = JSONUtilities.getStringFromJsonObject((JSONObject)childProperty, (String)"name");
                childProperty.put("name", (Object)(childName + "/" + propertyName));
                childProperty.put("namePrefix", (Object)childName);
                result.put((Object)childProperty);
            }
        }
        return result;
    }
}

