/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client.ant;

import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.ubuild.codestation.client.BuildLife;
import com.urbancode.ubuild.codestation.client.BuildLifeLookup;
import com.urbancode.ubuild.codestation.client.BuildProcess;
import com.urbancode.ubuild.codestation.client.BuildProcessLookup;
import com.urbancode.ubuild.codestation.client.CodestationClient;
import com.urbancode.ubuild.codestation.client.ant.CodestationTask;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;

public class ResolveTask
extends CodestationTask {
    private String projectId;
    private String processId;
    private String buildLifeId;
    private String stamp;
    private File xmlConfigFile;
    private String xmlConfigContent;
    private File xmlOutputFile;

    public void execute() throws BuildException {
        String buildId;
        long start = System.currentTimeMillis();
        this.printVersionInfo();
        if (this.buildLifeId == null && (buildId = System.getenv("BUILD_LIFE_ID")) != null && buildId.length() > 0) {
            try {
                this.buildLifeId = buildId;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (this.xmlConfigFile != null) {
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            try {
                FileUtils.writeFileToOutput((File)this.xmlConfigFile, (OutputStream)outs);
                this.xmlConfigContent = outs.toString("UTF-8");
            }
            catch (IOException e) {
                throw new BuildException("Unable to read xmlFile '" + this.xmlConfigFile + "': " + e.getMessage(), (Throwable)e);
            }
        } else {
            if (this.projectId == null) {
                throw new BuildException("Project is required");
            }
            if (this.processId == null) {
                throw new BuildException("Process is required");
            }
            if (this.buildLifeId != null && this.stamp != null) {
                throw new BuildException("BuildLife and stamp are mutually exclusive");
            }
        }
        try {
            CodestationClient client = this.configureBaseClient();
            File destinationDir = new File(this.basedir);
            BuildLifeLookup buildLifeLookup = client.getBuildLifeLookup();
            BuildProcessLookup processLookup = client.getBuildProcessLookup();
            BuildLife buildLife = null;
            if (this.buildLifeId != null) {
                buildLife = buildLifeLookup.findBuildLife(String.valueOf(this.buildLifeId));
            } else if (this.stamp != null) {
                buildLife = buildLifeLookup.findLatestBuildLife(this.projectId, this.processId, this.stamp, null, null);
            }
            if (this.xmlConfigContent != null) {
                if (buildLife == null) {
                    BuildProcess process = processLookup.findBuildProcess(this.projectId, this.processId);
                    client.downloadDependencies(process, this.xmlConfigFile, destinationDir);
                } else {
                    client.downloadDependencies(buildLife, this.xmlConfigFile, destinationDir);
                }
            } else if (buildLife != null) {
                client.downloadDependencies(buildLife, destinationDir);
            } else {
                BuildProcess process = processLookup.findBuildProcess(this.projectId, this.processId);
                client.downloadDependencies(process, destinationDir);
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Error resolving dependency artifacts: " + this.getRootExceptionMessage(e);
            throw new BuildException(message, (Throwable)e);
        }
        long duration = System.currentTimeMillis() - start;
        this.log("Task finished in " + duration + " ms");
    }

    public void setXmlFile(File xmlConfigFile) {
        this.xmlConfigFile = xmlConfigFile;
    }

    public void setXmlOutputFile(File xmlOutputFile) {
        this.xmlOutputFile = xmlOutputFile;
    }

    public void setProject(String aString) {
        this.projectId = aString;
    }

    public void setProcess(String aString) {
        this.processId = aString;
    }

    @Deprecated
    public void setWorkflow(String aString) {
        this.setProcess(aString);
    }

    public void setBuildLife(String buildLife) {
        if (buildLife != null && buildLife.length() > 0 && !buildLife.startsWith("${")) {
            this.buildLifeId = buildLife;
        }
    }
}

