/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.interceptors;

import com.urbancode.air.property.interceptors.InterceptorRegistry;
import com.urbancode.air.property.interceptors.ReadInterceptor;
import com.urbancode.air.property.interceptors.WriteInterceptor;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorRegistryImpl
implements InterceptorRegistry {
    private Set<ReadInterceptor<PropSheet>> propSheetReadInterceptors = new HashSet<ReadInterceptor<PropSheet>>();
    private Set<WriteInterceptor<PropSheet>> propSheetWriteInterceptors = new HashSet<WriteInterceptor<PropSheet>>();
    private Set<ReadInterceptor<PropSheetDef>> propSheetDefReadInterceptors = new HashSet<ReadInterceptor<PropSheetDef>>();
    private Set<WriteInterceptor<PropSheetDef>> propSheetDefWriteInterceptors = new HashSet<WriteInterceptor<PropSheetDef>>();

    InterceptorRegistryImpl() {
    }

    @Override
    public Set<ReadInterceptor<PropSheet>> getPropSheetReadInterceptors() {
        return this.propSheetReadInterceptors;
    }

    @Override
    public Set<WriteInterceptor<PropSheet>> getPropSheetWriteInterceptors() {
        return this.propSheetWriteInterceptors;
    }

    @Override
    public Set<ReadInterceptor<PropSheetDef>> getPropSheetDefReadInterceptors() {
        return this.propSheetDefReadInterceptors;
    }

    @Override
    public Set<WriteInterceptor<PropSheetDef>> getPropSheetDefWriteInterceptors() {
        return this.propSheetDefWriteInterceptors;
    }

    @Override
    public void interceptRead(PropSheet propSheet) {
        for (ReadInterceptor<PropSheet> interceptor : this.getPropSheetReadInterceptors()) {
            interceptor.interceptRead(propSheet);
        }
    }

    @Override
    public void interceptRead(PropSheetDef propSheetDef) {
        for (ReadInterceptor<PropSheetDef> interceptor : this.getPropSheetDefReadInterceptors()) {
            interceptor.interceptRead(propSheetDef);
        }
    }

    @Override
    public void interceptWrite(PropSheet propSheet) {
        for (WriteInterceptor<PropSheet> interceptor : this.getPropSheetWriteInterceptors()) {
            interceptor.interceptWrite(propSheet);
        }
    }

    @Override
    public void interceptWrite(PropSheetDef propSheetDef) {
        for (WriteInterceptor<PropSheetDef> interceptor : this.getPropSheetDefWriteInterceptors()) {
            interceptor.interceptWrite(propSheetDef);
        }
    }

    @Override
    public void registerPropSheetReadInterceptor(ReadInterceptor<PropSheet> readInterceptor) {
        this.propSheetReadInterceptors.add(readInterceptor);
    }

    @Override
    public void registerPropSheetWriteInterceptor(WriteInterceptor<PropSheet> writeInterceptor) {
        this.propSheetWriteInterceptors.add(writeInterceptor);
    }

    @Override
    public void registerPropSheetDefReadInterceptor(ReadInterceptor<PropSheetDef> readInterceptor) {
        this.propSheetDefReadInterceptors.add(readInterceptor);
    }

    @Override
    public void registerPropSheetDefWriteInterceptor(WriteInterceptor<PropSheetDef> writeInterceptor) {
        this.propSheetDefWriteInterceptors.add(writeInterceptor);
    }

    @Override
    public void clear() {
        this.propSheetReadInterceptors.clear();
        this.propSheetWriteInterceptors.clear();
        this.propSheetDefReadInterceptors.clear();
        this.propSheetDefWriteInterceptors.clear();
    }
}

