/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def.scripted;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_def.parser.JsonParser;
import com.urbancode.air.property.prop_def.parser.XmlParser;
import com.urbancode.air.property.prop_def.scripted.ScriptedPropInfo;
import com.urbancode.commons.util.logging.LogUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptedPropInfoHelper {
    static final Logger log = Logger.getLogger(ScriptedPropInfoHelper.class);
    private static final String LINE_SEPARATED_SPLITTER = "\\r?\\n";

    public List<PropDefAllowedValue> getAllowedValues(ScriptedPropInfo info, String rawData) {
        List<PropDefAllowedValue> result = new ArrayList<PropDefAllowedValue>();
        try {
            if (info.getFormat() == ScriptedPropInfo.DataFormat.JSON) {
                result = JsonParser.parseJson(rawData, info);
            } else if (info.getFormat() == ScriptedPropInfo.DataFormat.XML) {
                result = XmlParser.parseXml(rawData, info);
            } else if (info.getFormat() == ScriptedPropInfo.DataFormat.LINE_SEPARATED) {
                result = this.lineSeparatedParser(rawData, info);
            }
        }
        catch (Exception e) {
            LogUtil.logTrace((Logger)log, (Object)"Retreiving properties from ScriptedPropInfo failed", (Throwable)e);
        }
        return result;
    }

    public List<PropDefAllowedValue> lineSeparatedParser(String rawData, ScriptedPropInfo info) {
        ArrayList<PropDefAllowedValue> result = new ArrayList<PropDefAllowedValue>();
        String[] lines = rawData.split(LINE_SEPARATED_SPLITTER);
        if (lines.length == 0) {
            throw new TranslatableException("Unable to find any properties", new Object[0]);
        }
        for (String line : lines) {
            PropDefAllowedValue allowedValue;
            String[] prop = line.split(",");
            if (prop.length == 1) {
                allowedValue = new PropDefAllowedValue(info.getPropDef(), prop[0], prop[0]);
                result.add(allowedValue);
                continue;
            }
            if (prop.length != 2) continue;
            allowedValue = new PropDefAllowedValue(info.getPropDef(), prop[1], prop[0]);
            result.add(allowedValue);
        }
        return result;
    }
}

