/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.ssl.XTrustProvider;
import com.urbancode.ubuild.codestation.client.ArtifactDeliverPattern;
import com.urbancode.ubuild.codestation.client.AuthenticationCredentials;
import com.urbancode.ubuild.codestation.client.BuildLife;
import com.urbancode.ubuild.codestation.client.BuildLifeLookup;
import com.urbancode.ubuild.codestation.client.BuildProcess;
import com.urbancode.ubuild.codestation.client.CodestationClient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UBuildClient {
    private static final Logger log = Logger.getLogger(UBuildClient.class);
    final String uBuildUrl;
    final String user;
    final String password;
    final String project;
    final String workflow;
    final String status;
    CodestationClient codestationClient;
    AuthenticationCredentials creds;
    private Map<String, File> tempDirs = new HashMap<String, File>();

    public UBuildClient(String uBuildUrl, String user, String password, String project, String workflow, String status) {
        if (uBuildUrl.endsWith("/")) {
            uBuildUrl = uBuildUrl.substring(0, uBuildUrl.length() - 1);
        }
        this.uBuildUrl = uBuildUrl;
        this.user = user;
        this.password = password;
        this.project = project;
        this.workflow = workflow;
        this.status = status;
        XTrustProvider.install();
        this.creds = AuthenticationCredentials.createUsernamePasswordCredentials((String)user, (String)password);
        this.codestationClient = new CodestationClient(uBuildUrl, this.creds);
    }

    public String getLatestVersion() throws IOException {
        String result = null;
        BuildLifeLookup lookup = this.codestationClient.getBuildLifeLookup();
        try {
            BuildLife bl = lookup.findLatestBuildLife(this.project, this.workflow, null, this.status, null);
            if (bl != null) {
                result = bl.getId();
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not get build life for uBuild Project " + this.project + " and workflow " + this.workflow + "!"), (Throwable)e);
            result = null;
        }
        return result;
    }

    public List<String> getArtifactSetNamesForBuildLifeId(String blId) {
        HashSet<String> artSetNameSet = new HashSet<String>();
        ArrayList<String> result = new ArrayList<String>();
        try {
            ArtifactDeliverPattern[] patterns;
            BuildLife bl = this.codestationClient.getBuildLifeLookup().findBuildLife(blId);
            BuildProcess bc = bl.lookupBuildProcess();
            for (ArtifactDeliverPattern pattern : patterns = bc.getArtifactDeliverPatterns()) {
                String setName = pattern.getArtifactSet();
                artSetNameSet.add(setName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        result.addAll(artSetNameSet);
        return result;
    }

    public File downloadFiles(String version, List<String> artifactSets) throws Exception {
        File tempDir = this.getTempDir(version);
        if (artifactSets == null || artifactSets.size() == 0) {
            artifactSets = this.getArtifactSetNamesForBuildLifeId(version);
        }
        for (String setName : artifactSets) {
            File artifactSetDir = new File(tempDir, setName);
            if (!artifactSetDir.exists()) {
                artifactSetDir.mkdirs();
            }
            try {
                BuildLife bl = this.codestationClient.getBuildLifeLookup().findBuildLife(version);
                this.codestationClient.downloadArtifacts(bl, setName, new File[]{artifactSetDir});
            }
            catch (Exception e) {
                throw new RuntimeException("Could not resolve artifact set, '" + setName + "' (Project: " + this.project + ", Workflow: " + this.workflow + ", Buildlife: " + version + ")", e);
            }
        }
        return tempDir;
    }

    private File getTempDir(String version) throws IOException {
        File result = this.tempDirs.get(version);
        if (result == null) {
            result = new File(UUID.randomUUID().toString());
            IO.mkdirs(result);
            this.tempDirs.put(version, result);
        }
        return result;
    }

    protected void closeClient() {
    }
}

