/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet_def;

import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_value.PropValue;
import com.urbancode.commons.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropSheetDefValidator {
    public Map<String, String> validate(PropSheet propSheet) {
        HashMap<String, String> errors = new HashMap<String, String>();
        PropSheetDef propSheetDef = propSheet.getPropSheetDef();
        if (propSheetDef != null) {
            for (PropDef propDef : propSheetDef.getPropDefList()) {
                PropValue propValue = propSheet.getPropValueObject(propDef.getName());
                this.validate(propDef, propValue, errors);
            }
        }
        return errors;
    }

    protected void validate(PropDef propDef, PropValue propValue, Map<String, String> errors) {
        PropDef.PropDefType propType = propDef.getType();
        String name = propDef.getName();
        ArrayList<String> allowedValues = new ArrayList<String>();
        for (PropDefAllowedValue allowedValue : propDef.getAllowedValues()) {
            allowedValues.add(allowedValue.getValue());
        }
        String rawValue = propValue == null ? null : propValue.getValue();
        boolean secure = rawValue != null && (propValue.isSecure() != false || PropDef.PropDefType.SECURE.equals((Object)propType));
        ArrayList<String> selectedValues = new ArrayList<String>();
        if (propType.isMultiValued()) {
            if (rawValue != null) {
                String delimiterRegex = ",";
                Collections.addAll(selectedValues, rawValue.split(delimiterRegex));
            }
        } else {
            selectedValues.add(rawValue);
        }
        if (StringUtil.isEmpty((String)rawValue)) {
            if (propDef.isRequired()) {
                String label = propDef.getLabel() == null ? name : propDef.getLabel();
                errors.put(name, label + " is required.");
            }
        } else if (propType.hasAllowedValues() && !allowedValues.containsAll(selectedValues)) {
            if (secure) {
                String allowedValuesString = ((Object)allowedValues).toString();
                LinkedHashSet<String> illegalSelections = new LinkedHashSet<String>();
                illegalSelections.addAll(selectedValues);
                illegalSelections.removeAll(allowedValues);
                String illegalSelectionsString = ((Object)illegalSelections).toString();
                errors.put(name, "Provided value '" + illegalSelectionsString + "' is not in the allowed values '" + allowedValuesString + "'.");
            } else {
                errors.put(name, rawValue + " is not an allowed value.");
            }
        }
    }
}

