/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def;

import com.urbancode.air.property.prop_def.AbstractPropDefEventListener;
import com.urbancode.air.property.prop_def.PropDefCreatedEvent;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.services.event.Event;
import com.urbancode.air.services.event.criteria.Criteria;
import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;

public class PropDefCreatedListener
extends AbstractPropDefEventListener {
    static final Logger log = Logger.getLogger(PropDefCreatedListener.class);

    public void handleEvent(Event event) {
        PropDefCreatedEvent createdPropEvent = (PropDefCreatedEvent)event;
        this.updatePropSheets(createdPropEvent);
    }

    public Criteria[] getCriteria() {
        return null;
    }

    public String[] getEventTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(PropDefCreatedEvent.class.getCanonicalName());
        return result.toArray(new String[result.size()]);
    }

    private void updatePropSheets(PropDefCreatedEvent createdPropEvent) {
        Set<PropSheet> propSheets = this.getAffectedPropSheets(createdPropEvent);
        for (PropSheet propSheet : propSheets) {
            this.updatePropSheet(createdPropEvent, propSheet);
        }
    }

    private void updatePropSheet(PropDefCreatedEvent createdPropEvent, PropSheet propSheet) {
        PropSheetDef psPSD;
        PropSheetDef thisPSD;
        String propName = createdPropEvent.getPropDefName();
        if (this.isPropDefOverridden(propName, thisPSD = this.getPropSheetDef(createdPropEvent), psPSD = propSheet.getPropSheetDef())) {
            return;
        }
        String existingValue = propSheet.getPropValue(propName);
        if (existingValue != null && !existingValue.equals("")) {
            log.error((Object)String.format("Found an unexpected value '%s' when updating '%s' for PropDefCreatedEvent '%s'", existingValue, propSheet.toString(), createdPropEvent.getProperties().toString()));
        } else if (createdPropEvent.isSecure()) {
            propSheet.setSecurePropValue(propName, createdPropEvent.getDefaultValue());
        } else {
            propSheet.setPropValue(propName, createdPropEvent.getDefaultValue());
        }
    }
}

