/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.util.IO;
import com.urbancode.ubuild.codestation.client.ArtifactDeliverPattern;
import com.urbancode.ubuild.codestation.client.BuildLife;
import com.urbancode.ubuild.codestation.client.CodestationClient;
import java.io.InputStream;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

class ArtifactDeliverPatternLookup {
    private final CodestationClient client;

    ArtifactDeliverPatternLookup(CodestationClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArtifactDeliverPattern[] findArtifactDeliverPatterns(BuildLife buildLife) throws Exception {
        String findUrl = UriBuilder.fromPath((String)this.client.getUrl()).path("build-lives").path(buildLife.getId()).path("artifact-configs").build(new Object[0]).toString();
        ArtifactDeliverPattern[] artifactPatterns = new ArtifactDeliverPattern[]{};
        HttpGet method = this.client.createHttpGet(findUrl);
        try {
            HttpResponse response = this.client.executeHttpMethod((HttpRequestBase)method);
            int code = response.getStatusLine().getStatusCode();
            InputStream content = response.getEntity().getContent();
            switch (code) {
                case 200: {
                    String body = IO.readText((InputStream)content);
                    JSONObject json = new JSONObject(body);
                    JSONArray jsonArtifactPatterns = json.getJSONArray("artifactPatterns");
                    artifactPatterns = new ArtifactDeliverPattern[jsonArtifactPatterns.length()];
                    for (int i = 0; i < jsonArtifactPatterns.length(); ++i) {
                        JSONObject jsonArtifactPattern = jsonArtifactPatterns.getJSONObject(i);
                        String artifactSet = jsonArtifactPattern.getString("set");
                        String baseDirectory = jsonArtifactPattern.getString("dir");
                        JSONArray jsonIncludes = jsonArtifactPattern.getJSONArray("includes");
                        String[] includes = this.jsonArrayToStringArray(jsonIncludes);
                        JSONArray jsonExcludes = jsonArtifactPattern.getJSONArray("excludes");
                        String[] excludes = this.jsonArrayToStringArray(jsonExcludes);
                        artifactPatterns[i] = new ArtifactDeliverPattern(artifactSet, baseDirectory, includes, excludes);
                    }
                    break;
                }
                case 204: 
                case 404: {
                    throw new Exception("Build life not found to read artifact configurations: " + buildLife.getId());
                }
                case 500: {
                    throw new Exception("Server error looking up build life: " + IO.readChar((InputStream)content));
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
        return artifactPatterns;
    }

    private String[] jsonArrayToStringArray(JSONArray jsonArray) throws JSONException {
        String[] stringArray = new String[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            stringArray[i] = jsonArray.getString(i);
        }
        return stringArray;
    }
}

