/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def;

import com.urbancode.air.property.PropertyConfiguration;
import com.urbancode.air.property.prop_def.AbstractPropDefEventListener;
import com.urbancode.air.property.prop_def.PropDefDefaultValueEvent;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.services.event.Event;
import com.urbancode.air.services.event.criteria.Criteria;
import java.util.ArrayList;
import java.util.Set;
import org.hibernate.FlushMode;
import org.hibernate.Session;

public class PropDefDefaultValueListener
extends AbstractPropDefEventListener {
    public Criteria[] getCriteria() {
        return null;
    }

    public String[] getEventTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(PropDefDefaultValueEvent.class.getCanonicalName());
        return result.toArray(new String[result.size()]);
    }

    public void handleEvent(Event event) {
        PropDefDefaultValueEvent defaultValueEvent = (PropDefDefaultValueEvent)event;
        this.updatePropSheets(defaultValueEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePropSheets(PropDefDefaultValueEvent defaultValueEvent) {
        Session sess = PropertyConfiguration.getInstance().getSessionLookup().getSession();
        FlushMode mode = sess.getFlushMode();
        try {
            sess.setFlushMode(FlushMode.COMMIT);
            Set<PropSheet> propSheets = this.getAffectedPropSheets(defaultValueEvent);
            for (PropSheet propSheet : propSheets) {
                this.updatePropSheet(defaultValueEvent, propSheet);
            }
        }
        finally {
            sess.setFlushMode(mode);
        }
    }

    private void updatePropSheet(PropDefDefaultValueEvent defaultValueEvent, PropSheet propSheet) {
        PropSheetDef psPSD;
        String propName = defaultValueEvent.getPropDefName();
        String oldValue = defaultValueEvent.getOldValue();
        String newValue = defaultValueEvent.getNewValue();
        boolean secure = defaultValueEvent.isSecure();
        PropSheetDef thisPSD = this.getPropSheetDef(defaultValueEvent);
        if (this.isPropDefOverridden(propName, thisPSD, psPSD = propSheet.getPropSheetDef())) {
            return;
        }
        String existingValue = propSheet.getPropValue(propName);
        if (existingValue == null || existingValue.equals(oldValue)) {
            if (secure) {
                propSheet.setSecurePropValue(propName, newValue);
            } else {
                propSheet.setPropValue(propName, newValue);
            }
        }
    }
}

