/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet_def;

import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefVCHelper;
import com.urbancode.air.property.prop_sheet.PropSheetHandle;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.xml.XMLVCHelper;
import com.urbancode.commons.xml.DOMUtils;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropSheetDefVCHelper
extends XMLVCHelper<PropSheetDef> {
    public static final String PROP_SHEET_DEF_ELEMENT = "propSheetDef";
    public static final String PROP_SHEET_DEFS_ELEMENT = "propSheetDefs";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String PROP_SHEET_REFERENCES_ELEMENT = "propSheetReferences";
    public static final String PROP_SHEET_REFERENCE_ELEMENT = "propSheetReference";
    public static final String PROP_SHEET_REFERENCE_ID_ATTRIBUTE = "propSheetId";
    public static final String PROP_SHEET_REFERENCE_HANDLE_ATTRIBUTE = "propSheetHandle";
    public static final String TEMPLATE_ID = "templatePropDefSheetId";
    public static final String TEMPLATE_HANDLE = "templatePropDefSheetHandle";
    public static final String PROP_SHEET_GROUP_HANDLE = "propSheetGroupHandle";

    public PropSheetDef toObject(Element element) {
        String propSheetGroupHandleString;
        Element propSheetReferencesElement;
        PropSheetDef result = new PropSheetDef();
        result.id = this.getUUIDAttribute(element, ID_ATTRIBUTE);
        result.name = this.getNullableStringAttribute(element, NAME_ATTRIBUTE);
        result.description = this.getNullableStringAttribute(element, DESCRIPTION_ATTRIBUTE);
        PropDefVCHelper propDefHelper = new PropDefVCHelper();
        String propDefsName = propDefHelper.getObjectCollectionElementName();
        Element propDefsElement = DOMUtils.getFirstChild((Element)element, (String)propDefsName);
        result.propDefs = propDefHelper.toObjectList(propDefsElement);
        for (PropDef propDef : result.propDefs) {
            propDef.setPropSheetDef(result);
        }
        if (element.hasAttribute(TEMPLATE_ID)) {
            result.templatePropSheetDefId = this.getUUIDAttribute(element, TEMPLATE_ID);
        }
        if (element.hasAttribute(TEMPLATE_HANDLE)) {
            result.templateHandleString = element.getAttribute(TEMPLATE_HANDLE);
        }
        if ((propSheetReferencesElement = DOMUtils.getFirstChild((Element)element, (String)PROP_SHEET_REFERENCES_ELEMENT)) != null) {
            for (Element propSheetReferenceElement : DOMUtils.getChildElementArray((Element)propSheetReferencesElement, (String)PROP_SHEET_REFERENCE_ELEMENT)) {
                UUID propSheetId;
                String propSheetReferenceHandleString = propSheetReferenceElement.getAttribute(PROP_SHEET_REFERENCE_HANDLE_ATTRIBUTE);
                if (!StringUtils.isEmpty((String)propSheetReferenceHandleString)) {
                    Handle propSheetReferenceHandle = new Handle(propSheetReferenceHandleString);
                    PropSheetHandle propSheetHandle = new PropSheetHandle(result, propSheetReferenceHandle);
                    result.propSheetHandles.add(propSheetHandle);
                }
                if ((propSheetId = this.getUUIDAttribute(propSheetReferenceElement, PROP_SHEET_REFERENCE_ID_ATTRIBUTE)) == null) continue;
                result.propSheetIds.add(propSheetId);
            }
        }
        if (!StringUtils.isEmpty((String)(propSheetGroupHandleString = element.getAttribute(PROP_SHEET_GROUP_HANDLE)))) {
            result.propSheetGroupHandle = new Handle(propSheetGroupHandleString);
        }
        result.getPersistenceData().setDirty(false);
        return result;
    }

    public Element toXML(PropSheetDef object, Document doc) {
        Element propSheetReferenceElement;
        Element element = doc.createElement(this.getObjectElementName());
        element.setAttribute(ID_ATTRIBUTE, object.getId().toString());
        element.setAttribute(NAME_ATTRIBUTE, object.name);
        PropDefVCHelper propDefHelper = new PropDefVCHelper();
        Object[] propDefArray = object.propDefs.toArray(new PropDef[object.propDefs.size()]);
        element.appendChild(propDefHelper.toXML(propDefArray, doc));
        Element propSheetReferencesElement = doc.createElement(PROP_SHEET_REFERENCES_ELEMENT);
        element.appendChild(propSheetReferencesElement);
        if (object.templatePropSheetDefId != null) {
            element.setAttribute(TEMPLATE_ID, object.templatePropSheetDefId.toString());
        }
        if (object.templateHandleString != null) {
            element.setAttribute(TEMPLATE_HANDLE, object.templateHandleString);
        }
        for (UUID propSheetId : object.propSheetIds) {
            propSheetReferenceElement = doc.createElement(PROP_SHEET_REFERENCE_ELEMENT);
            propSheetReferenceElement.setAttribute(PROP_SHEET_REFERENCE_ID_ATTRIBUTE, propSheetId.toString());
            propSheetReferencesElement.appendChild(propSheetReferenceElement);
        }
        for (PropSheetHandle propSheetHandle : object.propSheetHandles) {
            propSheetReferenceElement = doc.createElement(PROP_SHEET_REFERENCE_ELEMENT);
            propSheetReferenceElement.setAttribute(PROP_SHEET_REFERENCE_HANDLE_ATTRIBUTE, propSheetHandle.getHandle().toString());
            propSheetReferencesElement.appendChild(propSheetReferenceElement);
        }
        if (object.propSheetGroupHandle != null) {
            element.setAttribute(PROP_SHEET_GROUP_HANDLE, object.propSheetGroupHandle.toString());
        }
        return element;
    }

    public String getObjectElementName() {
        return PROP_SHEET_DEF_ELEMENT;
    }

    public String getObjectCollectionElementName() {
        return PROP_SHEET_DEFS_ELEMENT;
    }

    public Class<PropSheetDef> getPersistentClass() {
        return PropSheetDef.class;
    }
}

