/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.common;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.logging.LogUtil;
import com.urbancode.commons.util.unix.Unix;
import com.urbancode.commons.util.unix.UnixCommandUnavailableException;
import com.urbancode.commons.util.unix.UnixPermissions;
import com.urbancode.vfs.common.ClientPathEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.log4j.Logger;

public class FileMetadataHelper {
    private static final Logger log = Logger.getLogger(FileMetadataHelper.class);
    private static final Unix unix = new Unix();
    private final boolean setPermissions;
    private final boolean setExecuteOnly;
    private Charset charset;

    public FileMetadataHelper(boolean setPermissions, boolean setExecuteOnly, Charset charset) {
        this.setPermissions = setPermissions;
        this.setExecuteOnly = setExecuteOnly;
        this.charset = charset;
    }

    public FileMetadataHelper(boolean setPermissions, boolean setExecuteOnly) {
        this.setPermissions = setPermissions;
        this.setExecuteOnly = setExecuteOnly;
    }

    public FileMetadataHelper() {
        this(false, false);
    }

    public void applyEntryMetadata(ClientPathEntry entry, File file) {
        this.applyEntryLastModified(entry, file);
    }

    public void applyEntryLastModified(ClientPathEntry entry, File file) {
        if (entry.getLastModified() != null) {
            LogUtil.logTrace((Logger)log, (Object)("Setting " + file + " last modified to " + entry.getLastModified()));
            file.setLastModified(entry.getLastModified());
        } else {
            LogUtil.logTrace((Logger)log, (Object)(file + " does not have a last modified metadata."));
        }
    }

    public void applyEntryPermissions(ClientPathEntry entry, File file) {
        Set<?> permissionViews = entry.getPermissionViews();
        if (this.setPermissions || this.setExecuteOnly) {
            if (!permissionViews.isEmpty()) {
                for (Object permissionView : permissionViews) {
                    if (permissionView instanceof UnixPermissions) {
                        UnixPermissions unixPermissions = (UnixPermissions)permissionView;
                        if (unix.isUnix()) {
                            try {
                                this.setUnixPermissions(file, unixPermissions);
                                continue;
                            }
                            catch (UnixCommandUnavailableException e) {
                                throw new RuntimeException("Error occurred setting Unix permissions/ownership", e);
                            }
                        }
                        LogUtil.logTrace((Logger)log, (Object)("Ignoring Unix permissions/ownership on non-Unix platform for " + file));
                        continue;
                    }
                    log.warn((Object)(file + " has unrecognized permissions of type " + permissionView.getClass()));
                }
            } else {
                LogUtil.logTrace((Logger)log, (Object)(file + " does not have permission metadata."));
            }
        }
    }

    public void createSymlink(File file, String linkPath) throws IOException, UnsupportedOperationException {
        if (!unix.isUnix()) {
            throw new UnsupportedOperationException("Symlink creation not supported on this platform.");
        }
        unix.ln(Unix.LinkType.SYMBOLIC, linkPath, file.getAbsolutePath());
    }

    private void setUnixPermissions(File file, UnixPermissions permissions) throws UnixCommandUnavailableException {
        if (permissions != null && file.exists()) {
            if (this.setExecuteOnly) {
                if (file.isFile() && (permissions.isUserExecutable() || permissions.isGroupExecutable() || permissions.isOtherExecutable())) {
                    boolean ownerOnly = !permissions.isGroupExecutable() && !permissions.isOtherExecutable();
                    file.setExecutable(true, ownerOnly);
                }
            } else if (this.setPermissions) {
                String message;
                LogUtil.logTrace((Logger)log, (Object)("Setting Unix permissions/ownership on " + file.getAbsolutePath() + " to " + permissions));
                try {
                    unix.chmod(file, permissions.getMode());
                }
                catch (UnixCommandUnavailableException e) {
                    throw e;
                }
                catch (IOException e) {
                    message = "Unable to set file mode of " + file + ": " + e.getMessage();
                    log.warn((Object)message);
                    LogUtil.logTrace((Logger)log, (Object)message, (Throwable)e);
                }
                try {
                    String user = this.trimToNull(permissions.getUser());
                    String group = this.trimToNull(permissions.getGroup());
                    if (user != null && group != null) {
                        unix.chown(file, user, group);
                    } else if (user != null) {
                        unix.chown(file, user);
                    } else if (group != null) {
                        unix.chgrp(file, group);
                    }
                }
                catch (UnixCommandUnavailableException e) {
                    throw e;
                }
                catch (IOException e) {
                    message = "Unable to set ownership of " + file + ": " + e.getMessage();
                    log.warn((Object)message);
                    LogUtil.logTrace((Logger)log, (Object)message, (Throwable)e);
                }
            }
        }
    }

    private String trimToNull(String str) {
        String result = null;
        if (str != null && (str = str.trim()).length() != 0) {
            result = str;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyCharsetMetadata(ClientPathEntry entry, File file) {
        File tempFile = null;
        if (entry.getCharset() != null && this.charset != null && !entry.getCharset().equals(this.charset)) {
            try {
                log.info((Object)("Changing Charset of " + file.getName() + " from: " + entry.getCharset().name() + " to: " + this.charset.name()));
                tempFile = File.createTempFile("temp", entry.getCharset().name());
                IO.copy((File)file, (File)tempFile);
                InputStreamReader reader = IO.reader((File)tempFile, (Charset)entry.getCharset());
                IO.copy((Reader)reader, (File)file, (Charset)this.charset);
            }
            catch (IOException e) {
                log.error((Object)("Failed to change character coding of: " + file.getName()), (Throwable)e);
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        } else {
            log.debug((Object)("No Charset conversion necessary source: " + entry.getCharset() + " dest: " + this.charset));
        }
    }
}

