/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def;

import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_def.http.HttpPropInfoVCHelper;
import com.urbancode.air.vc.xml.XMLVCHelper;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.xml.DOMUtils;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropDefVCHelper
extends XMLVCHelper<PropDef> {
    public static final String PROP_DEF_ELEMENT = "propDef";
    public static final String PROP_DEFS_ELEMENT = "propDefs";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String PLACEHOLDER_ATTRIBUTE = "placeholder";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String LABEL_ATTRIBUTE = "label";
    public static final String PATTERN_ATTRIBUTE = "pattern";
    public static final String REQUIRED_ATTRIBUTE = "required";
    public static final String HIDDEN_ATTRIBUTE = "hidden";
    public static final String DEFAULT_VALUE_ELEMENT = "defaultValue";
    public static final String LONG_DEFAULT_VALUE_ELEMENT = "longDefaultValue";
    public static final String DEFAULT_LABEL_ELEMENT = "defaultLabel";
    public static final String LONG_DEFAULT_LABEL_ELEMENT = "longDefaultLabel";
    public static final String ALLOWED_VALUES_ELEMENT = "allowedValues";
    public static final String ALLOWED_VALUE_ELEMENT = "allowedValue";

    public PropDef toObject(Element element) {
        Element longLabelElement;
        Element labelElement;
        Element longValueElement;
        List allowedValuesElement;
        String typeString;
        PropDef result = new PropDef();
        HttpPropInfoVCHelper httpHelper = new HttpPropInfoVCHelper();
        result.id = this.getUUIDAttribute(element, ID_ATTRIBUTE);
        result.name = element.getAttribute(NAME_ATTRIBUTE);
        result.description = element.getAttribute(DESCRIPTION_ATTRIBUTE);
        result.placeholder = element.getAttribute(PLACEHOLDER_ATTRIBUTE);
        result.pattern = element.getAttribute(PATTERN_ATTRIBUTE);
        result.typeName = typeString = element.getAttribute(TYPE_ATTRIBUTE);
        result.type = PropDef.PropDefType.valueOf(typeString);
        result.label = element.getAttribute(LABEL_ATTRIBUTE);
        result.required = this.getBooleanAttribute(element, REQUIRED_ATTRIBUTE);
        result.hidden = this.getBooleanAttribute(element, HIDDEN_ATTRIBUTE);
        if (result.type.isHttpBased()) {
            Element httpElement = DOMUtils.getFirstChild((Element)element, (String)httpHelper.getObjectElementName());
            result.httpPropInfo = httpHelper.toObject(httpElement);
            result.httpPropInfo.setPropDef(result);
        } else if (result.type.hasAllowedValues() && DOMUtils.getChildElementList((Element)element, (String)ALLOWED_VALUES_ELEMENT) != null && (allowedValuesElement = DOMUtils.getChildElementList((Element)element, (String)ALLOWED_VALUES_ELEMENT)).size() > 0) {
            List valueElements = DOMUtils.getChildElementList((Element)((Element)allowedValuesElement.get(0)), (String)ALLOWED_VALUE_ELEMENT);
            for (Element valueElem : valueElements) {
                String value = DOMUtils.getChildText((Element)valueElem);
                String label = StringUtil.trimToNull((String)valueElem.getAttribute(LABEL_ATTRIBUTE));
                result.addAllowedValue(value, label);
            }
        }
        Element valueElement = DOMUtils.getFirstChild((Element)element, (String)DEFAULT_VALUE_ELEMENT);
        if (valueElement != null) {
            result.defaultValue = DOMUtils.getChildText((Element)valueElement);
        }
        if ((longValueElement = DOMUtils.getFirstChild((Element)element, (String)LONG_DEFAULT_VALUE_ELEMENT)) != null) {
            result.longDefaultValue = DOMUtils.getChildText((Element)longValueElement);
        }
        if ((labelElement = DOMUtils.getFirstChild((Element)element, (String)DEFAULT_LABEL_ELEMENT)) != null) {
            result.defaultLabel = DOMUtils.getChildText((Element)labelElement);
        }
        if ((longLabelElement = DOMUtils.getFirstChild((Element)element, (String)LONG_DEFAULT_LABEL_ELEMENT)) != null) {
            result.longDefaultLabel = DOMUtils.getChildText((Element)longLabelElement);
        }
        return result;
    }

    public Element toXML(PropDef object, Document doc) {
        Element element = doc.createElement(this.getObjectElementName());
        HttpPropInfoVCHelper httpHelper = new HttpPropInfoVCHelper();
        element.setAttribute(ID_ATTRIBUTE, object.getId().toString());
        element.setAttribute(NAME_ATTRIBUTE, object.name);
        element.setAttribute(DESCRIPTION_ATTRIBUTE, object.description);
        element.setAttribute(PLACEHOLDER_ATTRIBUTE, object.placeholder);
        element.setAttribute(PATTERN_ATTRIBUTE, object.pattern);
        element.setAttribute(TYPE_ATTRIBUTE, object.typeName);
        element.setAttribute(LABEL_ATTRIBUTE, object.label);
        element.setAttribute(REQUIRED_ATTRIBUTE, Boolean.toString(object.required));
        element.setAttribute(HIDDEN_ATTRIBUTE, Boolean.toString(object.hidden));
        Element valuesElement = doc.createElement(ALLOWED_VALUES_ELEMENT);
        if (object.getType().isHttpBased()) {
            Element httpInfoElement = httpHelper.toXML(object.getHttpPropInfo(), doc);
            element.appendChild(httpInfoElement);
        } else {
            for (PropDefAllowedValue allowedValue : object.getAllowedValues()) {
                Element valueElement = doc.createElement(ALLOWED_VALUE_ELEMENT);
                valueElement.setAttribute(LABEL_ATTRIBUTE, allowedValue.getLabel());
                valueElement.setTextContent(allowedValue.getValue());
                valuesElement.appendChild(valueElement);
            }
        }
        element.appendChild(valuesElement);
        if (!StringUtils.isEmpty((String)object.defaultValue)) {
            element.appendChild(this.createTextElement(doc, DEFAULT_VALUE_ELEMENT, object.defaultValue));
        }
        if (!StringUtils.isEmpty((String)object.longDefaultValue)) {
            element.appendChild(this.createTextElement(doc, LONG_DEFAULT_VALUE_ELEMENT, object.longDefaultValue));
        }
        if (!StringUtils.isEmpty((String)object.defaultLabel)) {
            element.appendChild(this.createTextElement(doc, DEFAULT_LABEL_ELEMENT, object.defaultLabel));
        }
        if (!StringUtils.isEmpty((String)object.longDefaultLabel)) {
            element.appendChild(this.createTextElement(doc, LONG_DEFAULT_LABEL_ELEMENT, object.longDefaultLabel));
        }
        return element;
    }

    public String getObjectElementName() {
        return PROP_DEF_ELEMENT;
    }

    public String getObjectCollectionElementName() {
        return PROP_DEFS_ELEMENT;
    }

    public String getPath(PropDef propDef) {
        throw new UnsupportedOperationException("Cannot get paths for PropDef.");
    }

    public Class<PropDef> getPersistentClass() {
        return PropDef.class;
    }
}

