/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def.http;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.lookup.PropSheetHelpersLookup;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_def.http.HttpPropInfoHelper;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.crypto.CryptStringUtil;
import com.urbancode.persistence.IDGenerator;
import com.urbancode.persistence.hibernate.AbstractEntity;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="propSheetsCache")
@Entity
@Table(name="ps_http_prop_info", uniqueConstraints={@UniqueConstraint(columnNames={"prop_def_id"})})
public class HttpPropInfo
extends AbstractEntity<UUID> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @Type(type="uuid-char")
    protected UUID id = IDGenerator.createID();
    @NotNull
    @OneToOne(optional=false)
    @JoinColumn(name="prop_def_id", updatable=false)
    protected PropDef propDef = null;
    @NotNull
    @Column(name="url")
    protected String url = null;
    @Column(name="username")
    protected String username = null;
    @Column(name="password")
    protected String password = null;
    @NotNull
    @Column(name="data_format")
    protected String formatName = HttpDataFormat.JSON.toString();
    protected transient HttpDataFormat format;
    @NotNull
    @Column(name="data_auth_type")
    protected String authenticationType = HttpAuthenticationType.BASIC.toString();
    protected transient HttpAuthenticationType httpAuthenticationType;
    @Column(name="base_path")
    protected String basePath = null;
    @Column(name="value_path")
    protected String valuePath = null;
    @Column(name="label_path")
    protected String labelPath = null;
    @Column(name="resolve_http_url")
    protected String resolveHttpValuesUrl = null;

    public HttpPropInfo() {
    }

    public HttpPropInfo(PropDef propDef) {
        this.propDef = propDef;
    }

    public HttpPropInfo(PropDef propDef, HttpPropInfo copy) {
        this.propDef = propDef;
        this.basePath = copy.basePath;
        this.valuePath = copy.valuePath;
        this.labelPath = copy.labelPath;
        this.url = copy.url;
        this.username = copy.username;
        try {
            this.setPassword(CryptStringUtil.decrypt((String)copy.getPassword()));
        }
        catch (GeneralSecurityException e) {
            throw new TranslatableException("Unable to copy HTTP property's password", (Throwable)e, new Object[0]);
        }
        this.setFormat(copy.getFormat());
        this.setAuthenticationType(copy.getAuthenticationType());
    }

    public UUID getId() {
        return this.id;
    }

    public PropDef getPropDef() {
        return this.propDef;
    }

    public void setPropDef(PropDef propDef) {
        this.propDef = propDef;
        if (this.propDef.getPropSheetDef() != null) {
            this.setDirty();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.setDirty();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.setDirty();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) throws GeneralSecurityException {
        if (StringUtil.isEmpty((String)password)) {
            this.password = password;
        } else if (!password.equals("****")) {
            this.password = CryptStringUtil.encrypt((String)password);
        }
        this.setDirty();
    }

    public HttpDataFormat getFormat() {
        if (this.format == null) {
            this.format = HttpDataFormat.valueOf(this.formatName);
        }
        return this.format;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormat(HttpDataFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("Data format is required.");
        }
        this.format = format;
        this.formatName = format.toString();
        this.setDirty();
    }

    public void setFormatName(String formatName) {
        if (StringUtils.isBlank((String)formatName)) {
            throw new IllegalArgumentException("Format name is required.");
        }
        this.formatName = formatName;
        this.format = HttpDataFormat.valueOf(formatName);
        this.setDirty();
    }

    public HttpAuthenticationType getHttpAuthenticationType() {
        if (this.httpAuthenticationType == null) {
            this.httpAuthenticationType = HttpAuthenticationType.valueOf(this.authenticationType);
        }
        return this.httpAuthenticationType;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setHttpAuthenticationType(HttpAuthenticationType httpAuthenticationType) {
        if (httpAuthenticationType == null) {
            throw new IllegalArgumentException("Http Authentication type is required.");
        }
        this.httpAuthenticationType = httpAuthenticationType;
        this.authenticationType = this.authenticationType.toString();
        this.setDirty();
    }

    public void setAuthenticationType(String authenticationType) {
        if (StringUtils.isBlank((String)authenticationType)) {
            throw new IllegalArgumentException("Authentication type is required.");
        }
        this.authenticationType = authenticationType;
        try {
            this.httpAuthenticationType = HttpAuthenticationType.valueOf(authenticationType);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(authenticationType + " is not a supported Authentication type.");
        }
        this.setDirty();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
        this.setDirty();
    }

    public String getValuePath() {
        return this.valuePath;
    }

    public void setValuePath(String valuePath) {
        this.valuePath = valuePath;
        this.setDirty();
    }

    public String getLabelPath() {
        return this.labelPath;
    }

    public void setLabelPath(String labelPath) {
        this.labelPath = labelPath;
        this.setDirty();
    }

    public String getResolveHttpValuesUrl() {
        return this.resolveHttpValuesUrl;
    }

    public void setResolveHttpValuesUrl(String resolveUrl) {
        this.resolveHttpValuesUrl = resolveUrl;
        this.setDirty();
    }

    public List<PropDefAllowedValue> getAllowedValues() {
        HttpPropInfoHelper helper = PropSheetHelpersLookup.getHttpPropInfoHelper();
        return helper.getAllowedValues(this);
    }

    private void setDirty() {
        if (this.propDef != null && this.propDef.getPropSheetDef() != null) {
            this.propDef.getPropSheetDef().getPersistenceData().setDirty(true);
        }
    }

    String getCacheKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName()).append("[");
        sb.append(this.getUsername()).append("@").append(this.getUrl());
        sb.append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HttpAuthenticationType {
        BASIC,
        OAUTH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HttpDataFormat {
        JSON,
        XML;

    }
}

