/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def;

import com.urbancode.air.property.PropertyConfiguration;
import com.urbancode.air.property.prop_def.AbstractPropDefEvent;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet.PropSheetLookup;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactory;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactoryRegistry;
import com.urbancode.air.services.event.EventListener;
import com.urbancode.air.vc.Handle;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropDefEventListener
implements EventListener {
    protected boolean isPropDefOverridden(String propName, PropSheetDef ancestorPSD, PropSheetDef leafPSD) {
        boolean isOverriden = false;
        boolean done = false;
        for (PropSheetDef curPSD = leafPSD; curPSD != null && !done; curPSD = curPSD.getTemplate()) {
            if (curPSD.equals((Object)ancestorPSD)) {
                done = true;
                continue;
            }
            if (curPSD.getDirectPropDef(propName) == null) continue;
            isOverriden = true;
            done = true;
        }
        return isOverriden;
    }

    protected Set<PropSheet> getAffectedPropSheets(AbstractPropDefEvent defaultValueEvent) {
        PropSheetDef propSheetDef = this.getPropSheetDef(defaultValueEvent);
        HashSet<PropSheet> result = new HashSet<PropSheet>();
        if (propSheetDef != null) {
            result.addAll(propSheetDef.getPropSheetList());
            PropSheetLookup propSheetLookup = PropertyConfiguration.getInstance().getPropSheetLookup();
            if (propSheetLookup != null) {
                result.addAll(propSheetLookup.getPropSheetsForPropSheetDef(propSheetDef));
            }
        }
        return result;
    }

    protected PropSheetDef getPropSheetDef(AbstractPropDefEvent defaultValueEvent) {
        UUID propSheetDefId = defaultValueEvent.getPropSheetDefId();
        Handle propSheetDefHandle = defaultValueEvent.getPropSheetDefHandle();
        PropSheetDefFactory factory = PropSheetDefFactoryRegistry.getFactory();
        PropSheetDef result = propSheetDefId != null ? factory.getPropSheetDefForId(propSheetDefId) : factory.getPropSheetDefForHandle(propSheetDefHandle);
        return result;
    }
}

