/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def;

import com.urbancode.air.property.prop_def.AbstractPropDefEvent;
import com.urbancode.air.property.prop_def.PropDef;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class PropDefDefaultValueEvent
extends AbstractPropDefEvent {
    private static final long serialVersionUID = 1161561616L;
    private static final String PROP_SHEET_DEF_ID = "propSheetDefId";
    private static final String PROP_SHEET_DEF_HANDLE = "propSheetDefHandle";
    private static final String PROP_DEF_NAME = "propDefName";
    private static final String OLD_VALUE = "oldValue";
    private static final String NEW_VALUE = "newValue";
    private static final String SECURE = "secure";
    private static final String REQUIRED = "required";
    private String oldValue;
    private String newValue;
    private boolean secure;
    private boolean required;

    public PropDefDefaultValueEvent(PropDef propDef) {
        super(propDef);
        this.oldValue = propDef.getDefaultValue();
        this.newValue = propDef.getDefaultValue();
        this.secure = propDef.isSecure();
        this.required = propDef.isRequired();
        this.setProperties(this.createJson());
    }

    public PropDefDefaultValueEvent(PropDef propDef, String oldValue, String newValue) {
        super(propDef);
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.secure = propDef.isSecure();
        this.required = propDef.isRequired();
        this.setProperties(this.createJson());
    }

    private JSONObject createJson() {
        JSONObject result = new JSONObject();
        try {
            result.put(PROP_SHEET_DEF_ID, (Object)this.propSheetDefId);
            result.put(PROP_SHEET_DEF_HANDLE, (Object)this.propSheetDefHandle);
            result.put(PROP_DEF_NAME, (Object)this.propDefName);
            result.put(OLD_VALUE, (Object)this.oldValue);
            result.put(NEW_VALUE, (Object)this.newValue);
            result.put(SECURE, this.secure);
            result.put(REQUIRED, this.required);
        }
        catch (JSONException e) {
            throw new RuntimeException("Error creating event JSON", e);
        }
        return result;
    }

    public String getOldValue() {
        return this.getString(OLD_VALUE);
    }

    public String getNewValue() {
        return this.getString(NEW_VALUE);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isRequired() {
        return this.required;
    }
}

