/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet_group;

import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_sheet_group.IPropSheetGroup;
import com.urbancode.persistence.IDGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientPropSheetGroup
implements IPropSheetGroup {
    private UUID id = IDGenerator.createID();
    private Map<String, PropSheet> psMap = new HashMap<String, PropSheet>();
    private Map<String, PropSheetDef> psdMap = new HashMap<String, PropSheetDef>();

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Set<PropSheet> getPropSheetSet() {
        return Collections.unmodifiableSet(new HashSet<PropSheet>(this.psMap.values()));
    }

    @Override
    public void addPropSheet(PropSheet propSheet) {
        String name = propSheet.getName();
        this.psMap.put(name, propSheet);
    }

    @Override
    public PropSheet getPropSheet(String name) {
        return this.psMap.get(name);
    }

    @Override
    public PropSheet getPropSheet(PropSheetDef propSheetDef) {
        String psdName = propSheetDef.getName();
        return this.getPropSheet(psdName);
    }

    @Override
    public void removePropSheet(String name) {
        this.psMap.remove(name);
    }

    @Override
    public void removePropSheet(PropSheetDef propSheetDef) {
        String psdName = propSheetDef.getName();
        this.removePropSheet(psdName);
    }

    @Override
    public void removePropSheet(PropSheet propSheet) {
        this.removePropSheet(propSheet.getName());
    }

    @Override
    public Set<PropSheetDef> getPropSheetDefSet() {
        return Collections.unmodifiableSet(new HashSet<PropSheetDef>(this.psdMap.values()));
    }

    @Override
    public void addPropSheetDef(PropSheetDef propSheetDef) {
        String name = propSheetDef.getName();
        this.psdMap.put(name, propSheetDef);
    }

    @Override
    public PropSheetDef getPropSheetDef(String name) {
        return this.psdMap.get(name);
    }

    @Override
    public void removePropSheetDef(String name) {
        this.psdMap.remove(name);
    }

    @Override
    public void removePropSheetDef(PropSheetDef propSheetDef) {
        this.removePropSheetDef(propSheetDef.getName());
    }

    @Override
    public void setPropValue(String name, String value) {
        String[] parts = name.split("/", 2);
        String propSheetName = parts[0];
        String propName = parts[1];
        PropSheet ps = this.psMap.get(propSheetName);
        if (ps == null) {
            throw new IllegalArgumentException("Property sheet not found to set property '" + name + "'.");
        }
        ps.setPropValue(propName, value);
    }

    @Override
    public boolean isVersioned() {
        return false;
    }
}

