/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client.ant;

import com.urbancode.ubuild.codestation.client.BuildLife;
import com.urbancode.ubuild.codestation.client.BuildLifeLookup;
import com.urbancode.ubuild.codestation.client.CodestationClient;
import com.urbancode.ubuild.codestation.client.ant.CodestationTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrieveTask
extends CodestationTask {
    private String projectName;
    private String processName;
    private String buildLifeId;
    private String stamp;
    private String status;
    private String setName;

    public void execute() throws BuildException {
        long start = System.currentTimeMillis();
        this.validateConfiguration();
        try {
            CodestationClient client = this.configureBaseClient();
            BuildLifeLookup lookup = client.getBuildLifeLookup();
            BuildLife buildLife = null;
            buildLife = this.buildLifeId != null ? lookup.findBuildLife(this.buildLifeId) : lookup.findLatestBuildLife(this.projectName, this.processName, this.stamp, this.status, null);
            File target = new File(".");
            client.downloadArtifacts(buildLife, this.setName, target);
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Error retrieving artifacts: " + this.getRootExceptionMessage(e);
            throw new BuildException(message, (Throwable)e);
        }
        long duration = System.currentTimeMillis() - start;
        this.log("Task finished in " + duration + " ms");
    }

    private void validateConfiguration() {
        ArrayList<String> missingAttributes = new ArrayList<String>();
        if (this.projectName == null) {
            missingAttributes.add("project");
        }
        if (this.processName == null) {
            missingAttributes.add("build-process");
        }
        if (this.setName == null) {
            missingAttributes.add("setName");
        }
        if (!missingAttributes.isEmpty()) {
            throw new BuildException("Required field(s) left blank: " + this.generateMissingAttributesString(missingAttributes) + " or you may provide a localConfig to use instead.");
        }
    }

    private String generateMissingAttributesString(List<String> missingAttributes) {
        StringBuilder result = new StringBuilder();
        if (missingAttributes != null) {
            for (String missingAttribute : missingAttributes) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(missingAttribute);
            }
        }
        return result.toString();
    }

    public void setProject(String projectName) {
        this.projectName = projectName;
    }

    public void setProcess(String processName) {
        this.processName = processName;
    }

    @Deprecated
    public void setWorkflow(String workflowName) {
        this.setProcess(workflowName);
    }

    public void setBuildLife(String buildLifeId) {
        this.buildLifeId = buildLifeId;
    }

    public void setStamp(String stamp) {
        this.stamp = stamp;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setSetName(String setName) {
        this.setName = setName;
    }
}

