/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.ubuild.codestation.client.ArtifactDeliverPattern;
import com.urbancode.ubuild.codestation.client.ArtifactDeliverPatternLookup;
import com.urbancode.ubuild.codestation.client.BuildProcess;
import com.urbancode.ubuild.codestation.client.BuildProcessLookup;
import com.urbancode.ubuild.codestation.client.CodestationClient;
import com.urbancode.ubuild.codestation.xml.Dependency;

public class BuildLife {
    private final CodestationClient client;
    private final String buildLifeId;
    private final String codestationBuildLifeId;
    private final String repoId;
    private final String projectId;
    private final String processId;
    private final String codestationProjectId;
    private BuildProcess buildProcess;

    static BuildLife newBuildLife(CodestationClient client, String buildLifeId, String repoId, String projectId, String processId) {
        return new BuildLife(client, buildLifeId, null, repoId, projectId, processId, null);
    }

    static BuildLife newCodestationBuildLife(CodestationClient client, String codestationBuildLifeId, String repoId, String codestationProjectId) {
        return new BuildLife(client, null, codestationBuildLifeId, repoId, null, null, codestationProjectId);
    }

    static BuildLife fromDependency(CodestationClient client, Dependency dependency) {
        BuildLife buildLife = null;
        if (dependency.getCriteria() != null && dependency.getCriteria().getBuildLifeId() != null) {
            if (dependency.getProject() != null) {
                buildLife = BuildLife.newBuildLife(client, dependency.getCriteria().getBuildLifeId().toString(), dependency.getProject().getRepositoryId(), dependency.getProject().getProjectId().toString(), dependency.getProject().getProcessId().toString());
            } else if (dependency.getCsProject() != null) {
                buildLife = BuildLife.newCodestationBuildLife(client, dependency.getCriteria().getBuildLifeId().toString(), dependency.getCsProject().getRepositoryId(), dependency.getCsProject().getProjectId().toString());
            }
        }
        return buildLife;
    }

    private BuildLife(CodestationClient client, String buildLifeId, String codestationBuildLifeId, String repoId, String projectId, String processId, String codestationProjectId) {
        this.client = client;
        this.buildLifeId = buildLifeId;
        this.codestationBuildLifeId = codestationBuildLifeId;
        this.repoId = repoId;
        this.projectId = projectId;
        this.processId = processId;
        this.codestationProjectId = codestationProjectId;
    }

    public boolean isCodestation() {
        return this.codestationBuildLifeId != null;
    }

    public String getId() {
        return this.buildLifeId != null ? this.buildLifeId : this.codestationBuildLifeId;
    }

    public String getRepositoryId() {
        return this.repoId;
    }

    public BuildProcess lookupBuildProcess() throws Exception {
        if (this.buildProcess == null) {
            BuildProcessLookup lookup = new BuildProcessLookup(this.client);
            this.buildProcess = lookup.findBuildProcess(this.projectId, this.processId);
            ArtifactDeliverPatternLookup adpLookup = new ArtifactDeliverPatternLookup(this.client);
            ArtifactDeliverPattern[] artifactDeliverPatterns = adpLookup.findArtifactDeliverPatterns(this);
            this.buildProcess.setArtifactDeliverPatterns(artifactDeliverPatterns);
        }
        return this.buildProcess;
    }

    public String toString() {
        String s = super.toString();
        if (this.buildLifeId != null) {
            s = "Build Life " + this.buildLifeId;
        } else if (this.codestationBuildLifeId != null) {
            s = "CodeStation Build Life " + this.buildLifeId;
        }
        return s;
    }
}

