/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.UBuildClient;
import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        block14: {
            try {
                Properties props = new Properties();
                props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
                PropertyConfigurator.configure((Properties)props);
                Properties agentProps = new Properties();
                agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
                String charsetName = agentProps.getProperty("system.default.encoding");
                String uBuildUrl = this.inputProperties.getProperty("uBuildUrl");
                String uBuildUser = this.inputProperties.getProperty("user");
                String uBuildPassword = this.inputProperties.getProperty("password");
                String project = this.inputProperties.getProperty("project");
                String workflow = this.inputProperties.getProperty("workflow");
                String status = this.inputProperties.getProperty("status");
                boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
                boolean saveExecuteBits = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
                String artifactSets = this.inputProperties.getProperty("artifactSets");
                String componentName = this.inputProperties.getProperty("componentName");
                String extensionString = this.inputProperties.getProperty("extensions");
                String[] extensions = new String[]{};
                if (extensionString != null) {
                    extensions = extensionString.split(",");
                    for (int i = 0; i < extensions.length; ++i) {
                        extensions[i] = extensions[i].trim();
                    }
                }
                Charset charset = null;
                if (charsetName != null) {
                    charset = Charset.forName(charsetName);
                }
                String username = "PasswordIsAuthToken";
                String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
                String webUrl = System.getenv("AH_WEB_URL");
                URI url = new URI(webUrl);
                VersionClient versionClient = new VersionClient(url, username, password);
                ComponentClient componentClient = new ComponentClient(url, username, password);
                UBuildClient client = new UBuildClient(uBuildUrl, uBuildUser, uBuildPassword, project, workflow, status);
                String version = client.getLatestVersion();
                File tempDir = null;
                String[] includes = new String[]{"**/*"};
                String[] excludes = new String[]{};
                if (version != null) {
                    List versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                    boolean hasVersion = versions.contains(version);
                    System.out.println("Version from codestation: " + version);
                    if (!hasVersion) {
                        String versionId = versionClient.createVersion(componentName, version, "", true).toString();
                        this.outputProperties.setProperty("VersionID", versionId);
                        if (isUseVFS) {
                            try {
                                tempDir = client.downloadFiles(version, Arrays.asList(artifactSets));
                                System.out.println("Uploading artifact files.");
                                versionClient.addVersionFiles(componentName, versionId, tempDir, "", includes, excludes, saveExecuteBits, true, charset, extensions);
                            }
                            finally {
                                if (tempDir != null && tempDir.exists()) {
                                    FileUtils.deleteFile(tempDir);
                                }
                            }
                        } else {
                            System.out.println("Skipping Artifact Upload: Component is configured not to use codestation.");
                        }
                        versionClient.markImportFinished(componentName, versionId);
                    } else {
                        System.out.println(String.format("Component Already Has Version: %s", version));
                    }
                    break block14;
                }
                System.err.println("No build life could be found matching the given project, workflow, and status.");
                return 1;
            }
            catch (Exception e) {
                System.err.println(String.format("Error Creating New Version: %s", e.getMessage()));
                return 1;
            }
        }
        return 0;
    }
}

